﻿Public Class DelegateBeispiel

 ' === Funktion
 Public Function HoleWert(ByVal Parameter As Long) As String
  Console.WriteLine("Methodenaufruf...")
  Return "Wert " & Parameter
 End Function

 ' === Definition eines Funktionszeigertypen
 Public Delegate Function HoleWertDelegate(ByVal Parameter As Long) As String

 ' === Hauptprogramm
 Public Sub Test()

  ' --- Synchroner Aufruf
  Console.WriteLine("Asynchroner Aufruf...")
  Console.WriteLine("Ergebnis: " & HoleWert(2))

  ' --- Asynchroner Aufruf
  Console.WriteLine("Asynchroner Aufruf...")
  Dim del As New HoleWertDelegate(AddressOf Me.HoleWert)
  Dim Callback As New AsyncCallback(AddressOf Fertig)
  del.BeginInvoke(123, Callback, del)

  ' --- Warten
  For a As Integer = 1 To 10
   Console.Write("*")
   System.Threading.Thread.Sleep(100)
  Next

  Console.ReadLine()
 End Sub

 ' === Callback-Handler
 Public Sub Fertig(ByVal CallbackResult As IAsyncResult)
  Console.WriteLine("Aufruf fertig...")
  Dim del As HoleWertDelegate = CType(CallbackResult.AsyncState, HoleWertDelegate)
  Dim Ergebnis As String = del.EndInvoke(CallbackResult)
  Console.WriteLine("Ergebnis: " & Ergebnis)
 End Sub

End Class