﻿
' Option Strict On
Imports de.WWWings
Imports de.WWWings.PassagierSystem
Imports de.WWWings.Mitarbeitersystem

Namespace de.WWWings

 Public Class FluggesellschaftClient

  Dim WithEvents pass As Passagier

  Private Shared Sub AddHandlerPassagierCheckInEnde(ByVal f1 As Flug, ByVal p1 As Passagier, ByVal p2 As Passagier)
   p1.Buchen("NF1234")
   p1.Buchen("NF5678")
   Dim b As Buchung = f1 + p2 ' Entspricht       p2.Buchen("NF1234")
   p1.CheckIn("NF1234")
  End Sub
  Public Shared Sub run()
   Dim f1 As New Flug("NF1234", "Düsseldorf", "München")
   Dim f2 As New Flug("NF5678", "Düsseldorf", "New York")
   Dim p1 As New Passagier("Schröder", "Gerhard")
   Dim p2 As New Passagier("Merkel", "Angela")

   AddHandler Passagier.CheckInStart, AddressOf CheckInStartHandler
   ' AddHandler Passagier.CheckInEnde, AddressOf CheckInEndeHandler
   AddHandlerPassagierCheckInEnde(f1, p1, p2)

   Try
    p2.CheckIn("NF5678")
   Catch ex As PassagierNichtAufFlugGebucht
    Console.WriteLine("Einchecken nicht möglich, da Passagier nicht auf diesen Flug gebucht ist!")
   Catch ex As Exception
    Console.WriteLine("Es ist ein unerwarteter Fehler aufgetreten: " & ex.Message)
   End Try
   Console.WriteLine("Gesamtanzahl der Flüge: " & Flug.Fluege.Count)
   Console.WriteLine("Gesamtanzahl der Passagiere: " & Passagier.Passagiere.Count)
   For Each p As Passagier In CType(Passagier.Passagiere.Values, IEnumerable(Of Passagier))
    Console.WriteLine(p.GanzerName & " hat " & p.Fluege.Count & " gebucht!")
    'If p.AktuellerFlug IsNot Nothing Then Console.WriteLine("Aktueller Flug: " & p.AktuellerFlug.FlugNr)
   Next

   Dim pass As New Passagier("Schröder", "Gerhard")
   Dim pers As New Person("Merkel", "Angela")
   pers = pass
   ' pass = pers ' Erlaubt ohne Option Strict!
   pass = CType(pers, Passagier)
   pass.Info()
   pers.Info()

   Dim zahl As Integer = 1
   Dim text As String = zahl

   ' Test der generischen Klasse Mitarbeiterzuordnung
   Dim pass1 As New Passagier("Schwichtenberg", "Holger")
   Dim pilot1 As New Pilot("max", "müller")
   Dim pilot2 As New Pilot("max", "meier")
   Dim CockpitTeam As Mitarbeitersystem.Mitarbeiterzuordnung(Of pilot, pilot)
   'CockpitTeam = New Mitarbeitersystem.Mitarbeiterzuordnung(Of Pilot, Pilot)(pilot1, pilot2)
   ' Fehler: CockpitTeam = New Mitarbeiterzuordnung(Of Pilot, Pilot)(pilot1, pass1, f1)
   'Dim DateiTeam As New Mitarbeitersystem.Mitarbeiterzuordnung(Of System.IO.FileInfo, System.IO.DirectoryInfo)

  End Sub

  Shared Sub CheckInStartHandler(ByVal pass As Passagier)
   Console.WriteLine("Check-In beginnt... für " & pass.GanzerName)
  End Sub

  Shared Sub CheckInEndeHandler(ByVal pass As Passagier) Handles pass.CheckInEnde
   Static AnzahlPass As Int16 = 0
   AnzahlPass += 1
   Console.WriteLine(AnzahlPass & ". Passagier: " & pass.GanzerName)
  End Sub


 End Class


End Namespace
