﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion


using de.WWWings;
using de.WWWings.PassagierSystem;
using de.WWWings.MitarbeiterSystem;
using de.ITVisions.DemoViewer;

namespace de.WWWings.ConsoleClient
{

 [Demo]
 public class FluggesellschaftClient
 {
  //public static void DAL_Test1()
  //{

  // Demo.Print(new de.WWWings.Info().GetComponentInfoString());

  // for (int a = 0; a < 10; a++)
  // {
  //  de.WWWings.DAL.Flug_DataManager fm = new de.WWWings.DAL.Flug_DataManager();

  //  System.Data.DataSet ds = fm.AlleFluege_DS();

  //  Demo.Print(ds.Tables[0].Rows.Count);
  // }
  //}

  public  void run()
  {
   Demo.Print(new de.WWWings.Info().GetComponentInfoString());

   Passagier p1 = new Passagier("Schröder", "Gerhard");

   Demo.Print("Buchungen vorher: ");
  Demo.PrintReader(p1.AlleBuchungen());
   Demo.Print("Buchungen gelöscht: " + p1.AlleBuchungenLoeschen());
   Demo.Print("Buchungen nun: ");
   Util.ReaderToConsole(p1.AlleBuchungen());
   Demo.Print("Eine Einzelbuchung...");
   Demo.Print("Flug 504 gebucht. Restplätze: " + p1.Buchen(504));
   Demo.Print("Eine Mehrfachbuchung...");
   long[] FlugNummern = new long[] { 505, 567, 653, 630 };
   try
   {
    p1.Buchen(FlugNummern);
    foreach (long f in FlugNummern)
    {
     Demo.Print("Gebucht: Flug #" + f);
    }
   }
   catch (ApplicationException ex2)
   {
    Demo.Print("Mehrfachbuchung nicht erfolgreich! " + ex2.GetType().ToString() + "." + ex2.Message);
   
   }
   catch (Exception ex)
   {
    Demo.Print("Ein unerwarteter Fehler ist aufgetreten " + ex.GetType().ToString() + "." + ex.Message);
   }

   Demo.Print("Buchungen nachher: ");
  Demo.PrintReader(p1.AlleBuchungen());
 
  }

  public  void Run2()
  {
 
   //Passagier.CheckInStart += new Passagier.CheckInStartHandler(CheckInGestartet);
   Passagier.CheckInEnde += delegate(Passagier CheckedInPassagier)
   {
    Int16 AnzahlPass = 0;
    AnzahlPass += 1;
    Demo.Print(AnzahlPass + ". Passagier: " + CheckedInPassagier.GanzerName);
   };

   Flug f1 = new Flug(1234, "Düsseldorf", "München");
   Flug f2 = new Flug(678, "Düsseldorf", "New York");
   Passagier p1 = new Passagier("Schröder", "Gerhard");
   Passagier p2 = new Passagier("Merkel", "Angela");
   p1.Buchen(1234);
   p1.Buchen(5678);
   f1 = f1 + p2;
   p1.CheckIn(1234);

   try
   {
    p2.CheckIn(5678);
   }
   catch (de.WWWings.PassagierSystem.PassagierNichtAufFlugGebucht)
   {
    Demo.Print("Einchecken nicht möglich, da Passagier nicht auf diesen Flug gebucht ist!");
   }
   catch (Exception ex)
   {
    Demo.Print("Es ist ein unerwarteter Fehler aufgetreten: " + ex.Message);
   }
   Demo.Print("Gesamtanzahl der Flüge: " + Flug.Fluege.Count);
   Demo.Print("Gesamtanzahl der Passagiere: " + Passagier.Passagiere.Count);
   foreach (Passagier p in Passagier.Passagiere.Values)
   {
    Demo.Print(p.GanzerName + " hat " + p.Fluege.Count + " gebucht!");
    if (!(p.AktuellerFlug == null))
    {
     Demo.Print("Aktueller Flug: " + p.AktuellerFlug.FlugNr);
    }
   }
   // Generische Typen nutzen
   Mitarbeiterzuordnung<Pilot, Pilot> CockpitTeam;
   Pilot Pilot1 = new Pilot("Müller", "Max");
   Pilot Pilot2 = new Pilot("Meier", "Hans");
   CockpitTeam = new Mitarbeiterzuordnung<Pilot, Pilot>(Pilot1, Pilot2);
   f1.Pilot = Pilot1;

   // Typkonvertierungen
   Passagier pass = new Passagier("Schröder", "Gerhard");
   Person pers = new Person("Merkel", "Angela");
   pers = ((Person)pass);
   pass = (pers as Passagier);

   System.Collections.ArrayList a = new System.Collections.ArrayList();
   a.Add(new Object());

   pass = (a[0] as Passagier);
   //  pass = ((Passagier)a[0]);

   //  pass.Info();
   //  pers.Info();
   int zahl = 1;
   zahl++;
   //  string text = zahl;

 
  }

  static void CheckInGestartet(Passagier pass)
  {
   Demo.Print("Check-In beginnt... für " + pass.GanzerName);
  }


 }
}