Option Strict On
Imports System.Data
Imports System.Data.OleDb
Imports System.Globalization
Imports System.IO

Module ADONET
 Sub ADONET_ablauf()
  'ADONET_Connect()
  'ADONET_DR1()
  'ADONET_DS1()
  'ADONET_DS2()
  'ADONET_DS3()
  'ADONET_DS1()
  'ADONET_CommandBuilder()
  'ADONET_DS_aendern()
  'ADONET_DS_neuerDatensatz()
  'ADONET_DS_loeschen()
  'ADONET_join1()
  'ADONET_dynTabelle1()
  ADONET_DSXML1()
  ADONET_DSXML2()

 End Sub

 Public Const CONNSTRING As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=..\daten\EDVShop.mdb;"





 ' === Ausgabe einer Tabelle mit Hilfe eines DataSets
 Sub ADONET_DS1()
  Dim DS As System.Data.DataSet
  Dim Com As System.Data.OleDb.OleDbCommand
  Dim SQL As String
  Dim DR As DataRow
  Dim DT As DataTable

  outtitle("Produktliste mit DataSet ausgeben")

  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()

  ' --- Einlesen vorbereiten
  SQL = "SELECT * FROM Produkte WHERE kategorie=23"
  Dim DA As System.Data.OleDb.OleDbDataAdapter
  DA = New System.Data.OleDb.OleDbDataAdapter(SQL, CONNSTRING)

  ' --- Tabelle lesen
  DA.Fill(DS, "EDV-Antik")

  ' --- Ausgabe #1
  out("### Preisliste")

  '  Zugriff auf Tabelle
  DT = DS.Tables("EDV-Antik")

  ' Anzahl der Datenstze ausgeben
  out("Anzahl Produkte: " & DT.Rows.Count)

  ' Schleife ber alle Datenstze
  For Each DR In DT.Rows
   out(DR("name").ToString & " kostet " & DR("Preis").ToString)
   ' Zwei Alternativen:
   'out(DR!name.ToString & " kostet " & DR!Preis.ToString)
   'out(DR.Item("name").ToString & " kostet " & DR.Item("Preis").ToString)
  Next

  ' --- Ausgabe #2
  out("### Inhalt der Tabelle als CSV:")
  out(table_to_csv(DS.Tables("EDV-Antik")))

  ' --- Ausgabe #3
  out("### Inhalt der Tabelle als XML:")
  out(DS.GetXml)

 End Sub


 ' === Ausgabe mehrerer Tabellen mit Hilfe eines DataSets
 Sub ADONET_DS2()
  Dim DS As System.Data.DataSet
  Dim Com As System.Data.OleDb.OleDbCommand
  Dim SQL As String

  outtitle("Beispiel fr Multi-Table-DataSet")

  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()

  ' --- 1. Tabelle einlesen
  SQL = "SELECT * FROM Produkte where kategorie=23"
  AddToDS(DS, "EDV-Antik", CONNSTRING, SQL)

  ' --- 2. Tabelle einlesen
  SQL = "SELECT * FROM Bestellungen"
  AddToDS(DS, "Bestellungen", CONNSTRING, SQL)

  ' --- 3. Tabelle einlesen
  SQL = "SELECT * FROM Kunden"
  AddToDS(DS, "Kunden", CONNSTRING, SQL)

  ' --- Ausgaben der Tabellen
  out("--- Inhalt des DataSet als CSV:")
  out(table_to_csv(DS.Tables("EDV-Antik")))
  out(table_to_csv(DS.Tables("Bestellungen")))
  out(table_to_csv(DS.Tables("Kunden")))

  out("--- Inhalt des DataSet als XML:")
  out(DS.GetXml)

 End Sub


 ' === Ausgabe mehrerer Tabellen mit Hilfe eines DataSets und expliziter Connection
 Sub ADONET_DS3()
  Dim DS As System.Data.DataSet
  Dim Conn As System.Data.OleDb.OleDbConnection
  Dim Com As System.Data.OleDb.OleDbCommand
  Dim SQL As String

  ' --- Verbindung ffnen
  Conn = New OleDbConnection(CONNSTRING)
  Conn.Open()
  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()

  ' --- 1. Tabelle einlesen
  SQL = "SELECT * FROM Produkte where kategorie=23"
  AddToDS(DS, "EDV-Antik", Conn, SQL)

  ' --- 2. Tabelle einlesen
  SQL = "SELECT * FROM Bestellungen"
  AddToDS(DS, "Bestellungen", Conn, SQL)

  ' --- 3. Tabelle einlesen
  SQL = "SELECT * FROM Kunden"
  AddToDS(DS, "Kunden", Conn, SQL)

  ' --- Ausgaben der Tabellen
  out("--- Inhalt des DataSet als CSV:")
  out(table_to_csv(DS.Tables("EDV-Antik")))
  out(table_to_csv(DS.Tables("Bestellungen")))
  out(table_to_csv(DS.Tables("Kunden")))

  out("--- Inhalt des DataSet als XML:")
  out(DS.GetXml)

  ' --- Verbindung schlieen
  Conn.Close()

 End Sub

 ' === Verwendung des CommandBuilder zur Generierung von SQL-DML-Befehlen
 Sub ADONET_CommandBuilder()

  Const FAKTOR As Single = 1.1
  Const SQL As String = _
  "SELECT * FROM Bestellungen"

  ' --- Nicht erlaubter SQL-String
  '        Const SQL As String = _
  '      "SELECT * FROM Produkte, Bestellungen where Produkte.ID = Bestellungen.PID"

  Dim DA As System.Data.OleDb.OleDbDataAdapter
  Dim CB As System.Data.OleDb.OleDbCommandBuilder

  outtitle("Test des OLEDBCommandBuilder")

  ' --- Tabelle einlesen
  DA = New OleDbDataAdapter(SQL, CONNSTRING)
  CB = New OleDbCommandBuilder(DA)

  ' --- Ausgabe aus dem CommandBuilder-Objekt
  out("SELECT-Befehl: " & SQL)
  out("INSERT-Befehl: " & _
  CB.GetInsertCommand.CommandText())
  out("DELETE-Befehl: " & _
  CB.GetDeleteCommand.CommandText())
  out("UPDATE-Befehl: " & _
  CB.GetUpdateCommand.CommandText())

  ' --- Geht nicht!
  'out(CB.DataAdapter.InsertCommand.CommandText)

 End Sub


 ' === Hinzufgen eines neuen Datensatzes
 Sub ADONET_DS_neuerDatensatz()

  Const FAKTOR As Single = 1.1

  Const SQL As String = _
  "SELECT * FROM Bestellungen where KundenID = 0"

  Dim DS As System.Data.DataSet
  Dim DT As System.Data.DataTable
  Dim DR As System.Data.DataRow
  Dim DA As System.Data.OleDb.OleDbDataAdapter
  Dim CB As System.Data.OleDb.OleDbCommandBuilder

  outtitle("Datensatz mit DataSet anfgen")

  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()
  ' --- Adapter definieren
  DA = New OleDbDataAdapter(SQL, CONNSTRING)
  ' --- SQL-DML-Befehle erzeugen
  CB = New OleDbCommandBuilder(DA)
  ' --- Tabelle einlesen
  DA.Fill(DS, "DT_Bestellungen")

  ' --- Zugriff auf Tabelle
  DT = DS.Tables("DT_Bestellungen")

  ' --- Ausgabe der Tabelle
  out("--- Bisheriger Inhalt:")
  out(table_to_csv(DS.Tables("DT_Bestellungen")))

  ' --- ANFGEN EINES DATENSATZES
  DR = DT.NewRow()
  ' Fllen der Zeile
  DR("KundenID") = 2
  DR("PID") = 2
  DR("Menge") = 1
  DR("Datum") = DateTime.Today
  ' Anfgen der Zeile an Tabelle
  DT.Rows.Add(DR)

  ' --- Speichern der nderungn
  DA.Update(DS, "DT_Bestellungen")

  ' --- Ausgabe der Tabelle
  out("--- Neuer Inhalt:")
  out(table_to_csv(DS.Tables("DT_Bestellungen")))

 End Sub

 ' === ndern von Datenstzen in einer Tabelle
 Sub ADONET_DS_aendern()

  Const FAKTOR As Single = 1.1
  Const SQL As String = _
  "SELECT * FROM Produkte where Kategorie = 23"

  Dim DS As System.Data.DataSet
  Dim DT As System.Data.DataTable
  Dim DR As System.Data.DataRow
  Dim DA As System.Data.OleDb.OleDbDataAdapter
  Dim CB As System.Data.OleDb.OleDbCommandBuilder

  outtitle("Datensatz mit DataSet anfgen")

  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()
  ' --- Adapter definieren
  DA = New OleDbDataAdapter(SQL, CONNSTRING)
  ' --- SQL-DML-Befehle erzeugen
  CB = New OleDbCommandBuilder(DA)
  ' --- Tabelle einlesen
  DA.Fill(DS, "EDV-Antik")

  ' --- Zugriff auf Tabelle
  DT = DS.Tables("EDV-Antik")

  ' --- Ausgabe der Tabelle
  out("--- Bisheriger Zustand der Produkttabelle:")
  out(table_to_csv(DS.Tables("EDV-Antik")))

  ' --- AUSFHRUNG EINER PREISERHHUNG
  For Each DR In DT.Rows
   Dim Alterpreis As Double
   Dim NeuerPreis As Double

   Alterpreis = CDbl(DR("Preis"))
   NeuerPreis = Math.Round(Alterpreis * FAKTOR, 2)

   DR!Preis = NeuerPreis

   out(DR("Name").ToString & " wurde von " _
   & Alterpreis & " DM auf " _
   & NeuerPreis & " DM erhht!")
  Next

  ' --- nderungen an Datenquelle senden
  DA.Update(DS, "EDV-Antik")

  ' --- Ausgabe der Tabelle
  out("--- Neuer Zustand der Produkttabelle:")
  out(table_to_csv(DS.Tables("EDV-Antik")))

 End Sub


 ' === Lschen von Datenstzen in einem DataSet
 Sub ADONET_DS_loeschen()
  Dim DS As System.Data.DataSet
  Dim Com As System.Data.OleDb.OleDbCommand
  Dim SQL As String
  Dim DT As System.Data.DataTable
  Dim DR As System.Data.DataRow
  Dim DA As System.Data.OleDb.OleDbDataAdapter
  Dim CB As System.Data.OleDb.OleDbCommandBuilder

  outtitle("Datenstze lschen")

  ' --- Zusammensetzung des SQL-Befehls
  Dim heute As DateTime = DateTime.Today() ' aktuelles Datum
  Dim heuteus As String = _
  heute.ToString( _
  New System.Globalization.CultureInfo("en-us")) ' umformatieren
  SQL = "SELECT * FROM Bestellungen WHERE Datum = #" & heuteus & "#"

  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()
  ' --- Adapter definieren
  DA = New OleDbDataAdapter(SQL, CONNSTRING)
  ' --- SQL-DML-Befehle erzeugen
  CB = New OleDbCommandBuilder(DA)
  ' --- Tabelle einlesen
  DA.Fill(DS, "heutige_Bestellungen")

  ' --- Zugriff auf Tabelle
  DT = DS.Tables("heutige_Bestellungen")

  ' --- Ausgabe der Tabelle
  out("--- Bisheriger Inhalt der Tabelle:")
  out(table_to_csv(DS.Tables("heutige_Bestellungen")))

  ' --- Lschen aller Datenstze
  For Each DR In DT.Rows
   out("Bestellung von " & _
   DR!KundenID.ToString() & _
   " von " & DR!PID.ToString() & _
   " wird gelscht!")
   DR.Delete()
  Next

  ' --- nderungen zurckliefern
  DA.Update(DS, "heutige_Bestellungen")

  ' --- Ausgabe der Tabelle
  out("--- Neuer Inhalt der Tabelle:")
  out(table_to_csv(DS.Tables("heutige_Bestellungen")))

 End Sub


 ' === Verknpfung von Tabellen innerhalb eines DataSets
 Sub ADONET_join1()
  Dim DS As System.Data.DataSet
  Dim Conn As System.Data.OleDb.OleDbConnection
  Dim Com As System.Data.OleDb.OleDbCommand
  Dim DT As System.Data.DataTable
  Dim DR1 As System.Data.DataRow
  Dim DR2 As System.Data.DataRow
  Dim DR3 As System.Data.DataRow
  Dim DRel1 As System.Data.DataRelation
  Dim DRel2 As System.Data.DataRelation
  Dim DC1 As System.Data.DataColumn
  Dim DC2 As System.Data.DataColumn
  Dim SQL As String


  ' --- Verbindung ffnen
  Conn = New System.Data.OleDb.OleDbConnection(CONNSTRING)
  Conn.Open()
  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()

  ' --- 1. Tabelle einlesen
  SQL = "SELECT * FROM Produkte"
  AddToDS(DS, "Produkte", Conn, SQL)

  ' --- 2. Tabelle einlesen
  SQL = "SELECT * FROM Bestellungen"
  AddToDS(DS, "Bestellungen", Conn, SQL)

  ' --- 3. Tabelle einlesen
  SQL = "SELECT * FROM Kunden"
  AddToDS(DS, "Kunden", Conn, SQL)

  ' --- 1. Verknpfung erstellen
  DC1 = DS.Tables("Kunden").Columns("KundenID")
  DC2 = DS.Tables("Bestellungen").Columns("KundenID")
  DRel1 = New System.Data.DataRelation("Kunden mit Bestellungen", DC1, DC2)
  DS.Relations.Add(DRel1)

  ' --- 1. Verknpfung erstellen
  DC1 = DS.Tables("Produkte").Columns("ID")
  DC2 = DS.Tables("Bestellungen").Columns("PID")

  DRel2 = New System.Data.DataRelation("Produkte mit Bestellungen", DC1, DC2)
  DS.Relations.Add(DRel2)

  For Each DT In DS.Tables
   say(DT.TableName)
  Next

  DT = DS.Tables("Kunden")
  ' --- Schleife ber alle Kunden
  For Each DR1 In DT.Rows
   out(DR1!KundenName)
   ' --- Schleife ber alle zugeordneten Bestellungen
   For Each DR2 In DR1.GetChildRows(DRel1)
    Dim d As DateTime
    d = CType(DR2!Datum, DateTime)

    ' Ermitteln des Produktdatensatzes
    DR3 = DR2.GetParentRows(DRel2)(0)

    ' Ausgabe
    out("Bestellung vom " & _
    d.ToShortDateString() & ":" & _
    DR2!menge.ToString() & "x " & _
    DR3!Name.ToString())
   Next
  Next

  ' --- Verbindung schlieen
  Conn.Close()

 End Sub


 ' === Aufbau einer dynamischen Tabelle im Speicher
 Sub ADONET_dynTabelle1()
  Dim DR As DataRow
  Dim DT As DataTable
  Dim DS As DataSet

  outtitle("Erzeugung einer dynamischen Tabelle im Speicher")

  ' --- Erzeugen einer dynamischen Tabelle
  DT = New DataTable()
  ' Anfgen der Spalte an Tabelle
  With DT.Columns
   .Add("ComputerID", System.Type.GetType("System.Int32"))
   .Add("Computername", System.Type.GetType("System.String"))
   .Add("Aktiv", System.Type.GetType("System.Boolean"))
  End With

  out("Fllen der Tabelle...")
  ' --- Anfgen von Daten 

  ' Erzeugen der 1. Zeile
  DR = DT.NewRow()
  ' Fllen der Zeile
  DR("ComputerID") = "1"
  DR("Computername") = "Sonne2000"
  DR("Aktiv") = True
  ' Anfgen der Zeile an Tabelle
  DT.Rows.Add(DR)

  ' Erzeugen der 2. Zeile
  DR = DT.NewRow()
  ' Fllen der Zeile
  DR("ComputerID") = "2"
  DR("Computername") = "Mars"
  DR("Aktiv") = True
  ' Anfgen der Zeile an Tabelle
  DT.Rows.Add(DR)

  ' Erzeugen der 3. Zeile
  DR = DT.NewRow()
  ' Fllen der Zeile
  DR("ComputerID") = "3"
  DR("Computername") = "Saturn"
  DR("Aktiv") = False
  ' Anfgen der Zeile an Tabelle
  DT.Rows.Add(DR)

  ' --- Ausgabe
  out("Ausgabe der Tabelle als CSV...")
  out(table_to_csv(DT))


  ' -- Anfgen an ein DataSet
  out("Erzeugen eines DataSet...")
  ' Erzeugen eines DataSet
  DS = New DataSet()
  ' Anfgen der Spalte an Tabelle
  DS.Tables.Add(DT)

  ' --- Ausgabe als XML
  out("Ausgabe der DataSet als XML...")
  out(DS.GetXml)

 End Sub



 ' === Ausgabe eines DatSet als XML
 Sub ADONET_DSXML1()
  Dim DS As System.Data.DataSet
  Dim Com As System.Data.OleDb.OleDbCommand
  Dim SQL As String

  outtitle("Ausgabe eines DatSet als XML")

  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()

  ' --- Tabelle einlesen
  SQL = "SELECT * FROM Produkte where name like 'Amiga%'"
  Dim DA As System.Data.OleDb.OleDbDataAdapter
  DA = New System.Data.OleDb.OleDbDataAdapter(SQL, CONNSTRING)
  DA.Fill(DS, "EDV-Antik")

  ' --- XML ausgeben
  out("--- Schema:")
  out(DS.GetXmlSchema)
  out("--- Daten:")
  out(DS.GetXml)

 End Sub

 ' === Vernderung eines DataSets via XML
 Sub ADONET_DSXML2()
  Dim DS As System.Data.DataSet
  Dim Com As System.Data.OleDb.OleDbCommand
  Dim SQL As String

  outtitle("Vernderung eines DataSets via XML")

  ' --- DataSet erzeugen
  DS = New System.Data.DataSet()

  ' --- Tabelle einlesen
  SQL = "SELECT * FROM Produkte where name like 'Amiga%'"
  Dim DA As System.Data.OleDb.OleDbDataAdapter
  DA = New System.Data.OleDb.OleDbDataAdapter(SQL, CONNSTRING)
  DA.Fill(DS, "EDV-Antik")

  ' --- DataDocument erzeugen
  Dim DD As System.Xml.XmlDataDocument
  DD = New System.Xml.XmlDataDocument(DS)

  ' --- XML-Baum ausgeben
  out(DD.OuterXml)

  ' --- bestimmtes Element finden
  Dim XN As System.Xml.XmlNode
  XN = DD.SelectSingleNode("*//EDV-Antik[Name='Amiga 500']/Preis")

  ' --- nderungen zulassen
  DS.EnforceConstraints = False

  ' --- alten Wert auslesen
  Dim alterpreis As Double
  alterpreis = CType(XN.InnerText, Double)

  ' --- Neuen Wert ermitteln
  Dim neuerpreis As Double
  neuerpreis = alterpreis * 1.5

  ' --- Neuen Wert setzen
  XN.InnerText = neuerpreis.ToString

  ' --- Ausgabe der nderung
  out("Preis wurde von " _
  & alterpreis & " DM auf " _
  & neuerpreis & " DM erhht!")

  ' --- Kontrollausgabe des DataSets
  out("--- DataSet nach nderung:")
  out(DS.GetXml)

  ' --- Speicherung vorbereiten
  Dim CB As System.Data.OleDb.OleDbCommandBuilder
  CB = New OleDbCommandBuilder(DA)

  ' --- Speicherung des DataSets
  DA.Update(DS, "EDV-Antik")
  out("nderungen gespeichert!")

 End Sub

 Sub ADONET_DSXML3()

  Dim DS As New System.Data.DataSet()
  Dim fs As FileStream
  Dim sr As StreamReader
  Dim DR As DataRow
  Dim DT As DataTable
  Dim REL As DataRelation

  ' --- Datei ffnen
  fs = New FileStream("..\DATEN\hs.xml", _
  FileMode.Open, FileAccess.Read)
  ' --- Datei einlesen
  sr = New StreamReader(fs)
  ' --- Stream in DataSet einlesen
  DS.ReadXml(sr)

  ' --- Schleife ber alle Tabellen
  out("Tabellen:")
  For Each DT In DS.Tables
   out(DT.TableName)
   For Each REL In DT.ChildRelations
    out(" - " & REL.ChildTable.TableName)
   Next
  Next

  ' --- Zugriff auf einzelne Tabelle
  DT = DS.Tables("buch")
  ' --- Anzahl der Datenstze ausgeben
  out("Anzahl: " & DT.Rows.Count)

  ' --- Schleife ber alle Datenstze
  For Each DR In DT.Rows
   out(DR("Titel").ToString & " erschienen in " & DR("Jahr").ToString)
  Next

  ' --- Ausgabe in ein DataGrid
  Dim f As New FORM_Buchliste()
  f.DataGrid1.DataSource = DT
  f.Show()
 End Sub
End Module
