Imports System
Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Channels.Tcp

Enum ActivationType
 CAO
 SAO_Singleton
 SAO_SingleCall
End Enum

Enum ChannelType
 TCP
 HTTP
 IPC
End Enum
Public Class Host

 Public Shared Sub main(ByVal args As String())

  Dim PORT As Integer = 8123
  Dim TYP As ActivationType = ActivationType.CAO
  Dim CHANNELTYPE As ChannelType = CHANNELTYPE.TCP

  ' --- Konfigurationsdatei einlesen
  ' RemotingConfiguration.Configure("RemotingServer.exe.config")

  ' --- Kommandozeilenparameter auswerten
  If args.Length > 0 Then
   If args(0) = "CAO" Then TYP = ActivationType.CAO
   If args(0) = "SAOSC" Then TYP = ActivationType.SAO_SingeCall
   If args(0) = "SAOST" Then TYP = ActivationType.SAO_Singleton
  End If
  If args.Length > 1 Then
   PORT = args(1)
  End If
  If args.Length > 2 Then
   If args(2) = "HTTP" Then CHANNELTYPE = CHANNELTYPE.HTTP
   If args(2) = "TCP" Then CHANNELTYPE = CHANNELTYPE.TCP
   If args(2) = "IPC" Then CHANNELTYPE = CHANNELTYPE.IPC
  End If
  ' --- Channel festlegen
  Dim Channel As IChannel
  Select Case CHANNELTYPE
   Case CHANNELTYPE.TCP

    'Dim d As New System.Collections.Generic.Dictionary(Of String, Object)
    'd.Add("impersonationLevel", "Identify")
    'd.Add("encryption", "EncryptAndSign")
    'd.Add("authenticationMode", "IdentifyCallers")
    'd.Add("port", PORT)
    'Channel = New System.Runtime.Remoting.Channels.Tcp.TcpChannel(d, Nothing, Nothing)


    Channel = New System.Runtime.Remoting.Channels.Tcp.TcpChannel(PORT)

   Case CHANNELTYPE.HTTP
    Channel = New System.Runtime.Remoting.Channels.Http.HttpChannel(PORT)
   Case CHANNELTYPE.IPC
    Channel = New System.Runtime.Remoting.Channels.Ipc.IpcServerChannel(PORT)
   Case Else
    Throw New Exception("Nicht untersttzter Channel!")
  End Select
  Console.WriteLine("Starte Server auf Port " & PORT & " mit Protokoll " & CHANNELTYPE.ToString & "...")
  System.Runtime.Remoting.Channels.ChannelServices.RegisterChannel(Channel)
  ' optional: Mehrfachregistrierung
  ' System.Runtime.Remoting.Channels.ChannelServices.RegisterChannel(New TcpChannel(8888))
  ' --- Server Objekt holen
  Select Case TYP
   Case ActivationType.CAO
    RemotingConfiguration.ApplicationName = "SystemInfo"
    RemotingConfiguration.RegisterActivatedServiceType(GetType(de.ITVisions.N2C.SystemInfo))
   Case ActivationType.SAO_SingleCall
    RemotingConfiguration.RegisterWellKnownServiceType(GetType(de.ITVisions.N2C.SystemInfo), "SystemInfo", _
    WellKnownObjectMode.SingleCall)
   Case ActivationType.SAO_Singleton
    RemotingConfiguration.RegisterWellKnownServiceType(GetType(de.ITVisions.N2C.SystemInfo), "SystemInfo", _
    WellKnownObjectMode.Singleton)
  End Select
  Console.WriteLine("Aktivierungstyp: " & TYP.ToString())
  Console.WriteLine("Server ist bereit... (EINGABETASTE drcken zum Beenden)")
  Console.ReadLine()
  Console.WriteLine("Server beendet!")
 End Sub

End Class


