' === By-Reference-Object
'<Serializable()> --> By Value!!!
Public Class SystemInfo
 Inherits System.MarshalByRefObject
 Implements de.ITVisions.N2C.ISystemInfo, de.ITVisions.N2C.IRemotingObjectInfo

 Private _ObjektName As String = ""
 Private _InstanceID As Long
 Private _Creation As Date
 Private Shared _Instanzen As Integer = 0

 Public Overrides Function InitializeLifetimeService() As Object
  Dim lease As System.Runtime.Remoting.Lifetime.ILease = CType(MyBase.InitializeLifetimeService(), System.Runtime.Remoting.Lifetime.ILease)
  If lease.CurrentState = System.Runtime.Remoting.Lifetime.LeaseState.Initial Then
   lease.InitialLeaseTime = TimeSpan.FromMinutes(1)
   lease.RenewOnCallTime = TimeSpan.FromSeconds(1)
  End If
  Return lease
 End Function


 Public Sub New()
  _Instanzen += 1
  _InstanceID = _Instanzen
  _Creation = DateTime.Now
  Console.WriteLine("{0}: Instanz #{1} erzeugt.", Now, _InstanceID)
 End Sub 'New

 Protected Overrides Sub Finalize()
  Console.WriteLine("{0}: Instanz #{1} zerstrt.", Now, _InstanceID)
  _Instanzen -= 1
  MyBase.Finalize()
 End Sub 'Finalize

 Public Function GetInfoObject() As IComputerInfoObject Implements ISystemInfo.GetComputerInfoObject
  Return New ComputerInfoObject(Me.GetComputerName, Me.GetLocalTime)
 End Function

 Public Function GetComputerName() As String Implements de.ITVisions.N2C.ISystemInfo.GetComputerName
  Return My.Computer.Name
 End Function

 Public Function GetCurrentUser() As String Implements de.ITVisions.N2C.ISystemInfo.GetCurrentUser
  Return My.User.Name
 End Function

 Public Function GetLocalTime() As Date Implements de.ITVisions.N2C.ISystemInfo.GetLocalTime
  Return DateTime.Now()
 End Function

 Public Function GetFreeDriveSpace(ByVal DriveLetter As Char) As Long Implements de.ITVisions.N2C.ISystemInfo.GetFreeDriveSpace
  Return My.Computer.FileSystem.GetDriveInfo(DriveLetter).AvailableFreeSpace
 End Function

 Public Function GetObjectName() As String Implements IRemotingObjectInfo.GetObjectName
  Return Me._ObjektName
 End Function

 Public Function GetApplicationName() As String Implements IRemotingObjectInfo.GetApplicationName
  Return System.Windows.Forms.Application.ExecutablePath
 End Function


 Public Function IsByValueObject() As Boolean Implements IRemotingObjectInfo.IsByValueObject
  Return Not Me.GetType().IsMarshalByRef()
 End Function

 Public ReadOnly Property ObjectCount() As Long Implements IRemotingObjectInfo.ObjectCount
  Get
   Return SystemInfo._Instanzen
  End Get
 End Property

 Public ReadOnly Property ObjectCreationTime() As Date Implements IRemotingObjectInfo.ObjectCreationTime
  Get
   Return Me._Creation
  End Get
 End Property

 Public ReadOnly Property ObjectID() As Long Implements IRemotingObjectInfo.ObjectID
  Get
   Return Me._InstanceID
  End Get
 End Property

 Public Sub SetObjectTag(ByVal Tag As String) Implements IRemotingObjectInfo.SetObjectTag
  If Me._ObjektName = "" Then Me._ObjektName = Tag
 End Sub

 Public Sub StartGarbageCollection() Implements IRemotingObjectInfo.StartGarbageCollection
  Dim lease As System.Runtime.Remoting.Lifetime.ILease = CType(MyBase.InitializeLifetimeService(), System.Runtime.Remoting.Lifetime.ILease)
  Console.WriteLine("Verbleibende Lebensdauer: " & lease.CurrentLeaseTime.ToString())
  GC.Collect()
  Console.WriteLine("Garbage Collection started!")
 End Sub
End Class
