Imports System
Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Channels.Tcp

Public Class Client

 Enum ActivationType
  CAO
  SAO
 End Enum

 Enum ChannelType
  TCP
  HTTP
  IPC
 End Enum

 Public Delegate Function GetFreeDriveSpace(ByVal DriveLetter As Char) As Long
 Public Shared Sub Main(ByVal args() As String)

  ' --- Standardwerte fr Parameter
  Dim PORT As Integer = 8123
  Dim TYP As ActivationType = ActivationType.CAO
  Dim CHANNELTYPE As ChannelType = CHANNELTYPE.TCP
  Dim SERVER As String = "localhost"

  If args.Length > 0 Then
   If args(0) = "CAO" Then TYP = ActivationType.CAO
   If args(0) = "SAO" Then TYP = ActivationType.SAO
  End If

  If args.Length > 1 Then
   PORT = args(1)
  End If

  ' Channel festlegen
  If args.Length > 2 Then
   If args(2) = "HTTP" Then CHANNELTYPE = CHANNELTYPE.HTTP
   If args(2) = "TCP" Then CHANNELTYPE = CHANNELTYPE.TCP
   If args(2) = "IPC" Then CHANNELTYPE = CHANNELTYPE.IPC
  End If

  If args.Length > 3 Then
   SERVER = args(3)
  End If

  ' --- Konfigurationsdatei einlesen
  'RemotingConfiguration.Configure("RemotingClient.exe.config")

  ' --- Channel festlegen
  Dim Channel As IChannel
  Select Case CHANNELTYPE
   Case CHANNELTYPE.HTTP
    Channel = New Channels.Http.HttpChannel()
   Case CHANNELTYPE.TCP
    Channel = New Channels.Tcp.TcpChannel()
   Case CHANNELTYPE.IPC
    Channel = New Channels.Ipc.IpcChannel()
   Case Else
    Throw New Exception("Nicht untersttzter Channel!")
  End Select
  ChannelServices.RegisterChannel(Channel)

  ' tcp://localhost:8123
  Dim SERVERURL As String = CHANNELTYPE.ToString & "://" & SERVER & ":" & PORT & "/SystemInfo"
  ' Instanziieren
  Dim obj As Object
  Dim si As de.ITVisions.N2C.ISystemInfo
  Console.WriteLine("Aktivierungstyp: " & TYP.ToString())

  For a As Integer = 1 To 3
   Console.WriteLine("Objekt: " & a)
   Select Case TYP
    Case ActivationType.CAO
     ' --- Mit Activator
     'Dim ActivationParameters() As Object = {New System.Runtime.Remoting.Activation.UrlAttribute(SERVERURL)}
     'obj = Activator.CreateInstance(GetType(de.ITVisions.N2C.SystemInfo), Nothing, ActivationParameters)
     'si = CType(obj, de.ITVisions.N2C.ISystemInfo)
     ' --- Transparente Aktivierung
     If RemotingConfiguration.IsRemotelyActivatedClientType _
             (GetType(de.ITVisions.N2C.SystemInfo)) Is Nothing Then
      RemotingConfiguration.RegisterActivatedClientType _
             (GetType(de.ITVisions.N2C.SystemInfo), SERVERURL)
     End If
     si = New de.ITVisions.N2C.SystemInfo()
    Case ActivationType.SAO
     ' --- Mit Activator
     obj = Activator.GetObject(GetType(de.ITVisions.N2C.ISystemInfo), SERVERURL)
     si = CType(obj, de.ITVisions.N2C.ISystemInfo)
     ' --- Transparente Aktivierung
     'If RemotingConfiguration.IsWellKnownClientType _
     '        (GetType(de.ITVisions.N2C.ISystemInfo)) Is Nothing Then
     ' RemotingConfiguration.RegisterWellKnownClientType _
     '        (GetType(de.ITVisions.N2C.ISystemInfo), SERVERURL)
     'End If
     'si = New de.ITVisions.N2C.SystemInfo()
    Case Else
     Throw New Exception("Ungltiges Aktivierungsmodell!")
   End Select

   If si Is Nothing Then
    Console.WriteLine("Fehler: Entferntes Objekt nicht lokalisierbar!")
    Return
   End If

   ' --- Nutzung des entfernten Objekts
   si.SetObjectTag("Objekt #" & a)
   Console.WriteLine()
   Console.WriteLine("--- Aufruf des entfernten Objekts...")
   Console.WriteLine("1. Meta-Daten (IRemotingObjectInfo)")
   Console.WriteLine("Objekt-ID: " & si.ObjectID())
   Console.WriteLine("Objekt-Anzahl: " & si.ObjectCount())
   Console.WriteLine("Objekt-Erzeugung: " & si.ObjectCreationTime())
   Console.WriteLine("Objekt-Name: " & si.GetObjectName())
   Console.WriteLine("Application-Name: " & si.GetApplicationName())
   Console.WriteLine("Objekt-Typ: " & IIf(si.IsByValueObject(), "By-Value", "By-Reference"))
   Console.WriteLine("2. Nutz-Daten (ISystemInformation)")
   Console.WriteLine("Name des Servers: " & si.GetComputerName())
   Console.WriteLine("Zeit auf dem Server: " & si.GetLocalTime())
   si.GetComputerInfoObject.Test()

   Console.WriteLine("Start des asynchronen Aufrufs...")
   Dim cb As AsyncCallback = New AsyncCallback(AddressOf Client.AufrufErgebnis)
   Dim dfdp As GetFreeDriveSpace = New GetFreeDriveSpace(AddressOf si.GetFreeDriveSpace)
   dfdp.BeginInvoke("C", cb, dfdp)
   Console.WriteLine("Ende des Fernaufrufs!")
   Console.WriteLine()
   'System.Threading.Thread.Sleep(1)
  Next
  Console.ReadLine()
  Console.WriteLine("Aufruf der Garbage Collection auf dem entfernten System...")
  si.StartGarbageCollection()
  Console.WriteLine("Ende des Clients")
 End Sub 'Main

 Shared Sub AufrufErgebnis(ByVal ar As IAsyncResult)
  Console.WriteLine("Ergebnis des asynchronen Aufrufs:")
  Dim dfdp As GetFreeDriveSpace = CType(ar.AsyncState, GetFreeDriveSpace)
  Dim Ergebnis As Long = dfdp.EndInvoke(ar)
  Console.WriteLine("Platz auf Laufwerk C auf dem Server: " & Ergebnis)
 End Sub

End Class