using System;
using System.DirectoryServices;
using ActiveDs;
using de.ITVisions.DemoViewer;

namespace N2C.FCL
{

 [Demo]
 public class Verzeichnisdienste
 {

  // Anlegen eines Benutzers im Active Directory
  public void ADS_Benutzer_Anlegen()
  {
   // AD-spezifische Parameter, bitte anpassen!
   const string LDAP_OU = "LDAP://bochum/OU=essen,DC=IT-Objects,DC=net";
   const string NAME = "hs";
   const string PASSWORD = "sduzs3434/34";
   const string LDAP_Gruppe = "LDAP://bochum/CN=Domnen-Admins,CN=Users,DC=IT-Objects,DC=net";
   
   //  Anlegen eines User-Objects im Active Directory
   Demo.Print("# Anlegen des Benutzerkontos: " + NAME);

   // Zugriff auf IADS
   DirectoryEntry ou = new DirectoryEntry(LDAP_OU);
   // Zugriff auf IADSContainer
   DirectoryEntries c = ou.Children;
   // Neues Objekt erzeugen
   DirectoryEntry  u = c.Add("cn=" + NAME, "user");
   // Verzeichnisattribute festlegen
   u.Properties["sAMAccountName"].Add(NAME);
   u.Properties["l"].Add("Essen-Byfang");
   u.Properties["telephoneNumber"].Add("++49 201 7490700");
   u.Properties["mail"].Add("hs@IT-Visions.de");
   // nderungen speichern
   u.CommitChanges();
   Demo.Print("Benutzer angelegt: " + u.Path.ToString());
   // Kennwort setzen
   u.Invoke("SetPassword", PASSWORD);
   // Konto aktivieren
   ((ActiveDs.IADsUser)(u.NativeObject)).AccountDisabled = false;
   u.CommitChanges();
   Demo.Print("Benutzer aktiviert!");
   // AD-Benutzer einer AD-Gruppe hinzufgen
   // Zugriff auf Eintrag
   DirectoryEntry g = new DirectoryEntry(LDAP_Gruppe);
   // IADSGroup::Add() aufrufen
   g.Invoke("Add", u.Path.ToString());
   // Besttigung
   Demo.Print("Benutzer zu Gruppe hinzugefgt!");
  }


  // Ausfhren einer LDAP-Suche im AD
  
  public void ADS_Suche()
  {
   const string LDAP_Wurzel = "LDAP://essen/DC=IT-Objects,DC=net";
   const string BEDINGUNG = "(&(objectclass=user)(objectcategory=person)(cn=h*))";

   Demo.Print("Suchanfrage im ADS: " + BEDINGUNG);

   // Instanziierung der Suchklasse
   DirectorySearcher suche = new DirectorySearcher();
   // Festlegung des Ausgangspunkts
   suche.SearchRoot = new DirectoryEntry(LDAP_Wurzel);
   // Festlegung der LDAP-Query
   suche.Filter = BEDINGUNG;
   // Suchtiefe festlegen
   suche.SearchScope = SearchScope.Subtree;
   // Ergebnisattribute festlegen (!!! funktioniert in Beta nicht!!!)
   suche.PropertiesToLoad.Add("displayName");
   suche.PropertiesToLoad.Add("l");
   suche.PropertiesToLoad.Add("description");
   // Suche starten
   SearchResultCollection ergebnisliste = suche.FindAll();
   // Ergebnismenge ausgeben
   Demo.Print("Anzahl Ergebnisobjekte: " + ergebnisliste.Count);
   foreach (SearchResult ergebnis in ergebnisliste)
   {
    foreach (System.Collections.DictionaryEntry de in ergebnis.Properties)
    {
     Demo.Print(de.Key.ToString() + "=" + ((ResultPropertyValueCollection) de.Value)[0].ToString());
    }
// Ergebnis lesen (!!! funktioniert in Beta nicht!!!)
//    Demo.Print(ergebnis.Properties["displayName"].Count.ToString());
//    Demo.Print(ergebnis.Properties["displayName"][0].ToString());
//    Demo.Print(" wohnt in " + ergebnis.Properties["l"][0].ToString());
   }
  }
 }
}
