﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using System.Collections.Generic;
using System.Collections;
using de.ITVisions.DemoViewer;

namespace N2C.FCL
{
	public class Kunde
	{
		public int KundenNr;
  public string Name;
  public override string ToString()
  {
   return "Kunde.ID=" + KundenNr;
  }

  public override int GetHashCode()
  {
   return this.ToString().GetHashCode();
  }

  public Kunde() { }
  public Kunde(int KundenNr, string Name)
  {
   this.KundenNr = KundenNr;
   this.Name = Name;
   Demo.Print("Kunde angelegt: Nr=" + KundenNr + " Name=" + Name);
  }
 }

	public class StammKunde : Kunde
	{
		byte BonusStufe;
	}

	public class Lieferant
	{
		int LieferantenNr;
		string Name;
	}

 [Demo]
 public class SystemObjectDemo
 {

  public void ObjectID()
  {
   Kunde k1 = new Kunde(0815, "Meier");
   Demo.Print("Dieser Kunde als Zeichenkette:" + k1.ToString());
   Demo.Print("Dieser Kunde als Ganzzahl:" + k1.GetHashCode());

   Kunde k2 = new Kunde(4711, "Müller");
   Demo.Print("Dieser Kunde als Zeichenkette:" + k2.ToString());
   Demo.Print("Dieser Kunde als Ganzzahl:" + k2.GetHashCode());

   Kunde k3 = new Kunde(4711, "Müller");
   Demo.Print("Dieser Kunde als Zeichenkette:" + k3.ToString());
   Demo.Print("Dieser Kunde als Ganzzahl:" + k3.GetHashCode());
  }
 }
 [de.ITVisions.DemoViewer.Demo]
 public class CollectionDemo
	{
  public CollectionDemo()
  {
			// untypisierte Kollektion
			System.Collections.Queue Kunden1 = new System.Collections.Queue();
			Kunden1.Enqueue(new Kunde());
			Kunden1.Enqueue(new StammKunde());
			Kunden1.Enqueue(new Lieferant());

			// Generische Kollektion
			System.Collections.Generic.Queue<Kunde> Kunden2 = new System.Collections.Generic.Queue<Kunde>();
			Kunden2.Enqueue(new Kunde());
			Kunden2.Enqueue(new StammKunde());
			// Compilerfehler: Kunden.Add(new Lieferant());
		}
	}
}
