﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Security.AccessControl;
using de.ITVisions.DemoViewer;
using System.IO;
using System.Security;

namespace N2C_CS.FCL
{
 [Demo]
 class Security
 {

  public static void SecureString()
  {

   SecureString s = new SecureString();
   s.AppendChar('g');
   s.AppendChar('e');
   s.AppendChar('h');
   s.AppendChar('e');
   s.AppendChar('i');
   s.AppendChar('m');
   IntPtr p = System.Runtime.InteropServices.Marshal.SecureStringToBSTR(s);
   s.MakeReadOnly();
   s.AppendChar('2');
  }
  // Auslesen einer Datei-ACL
  public static void Auslesen()
  {
   const string FILENAME = @"d:\test\test.txt";

   // Hole ACL
   FileSecurity objFS = File.GetAccessControl(FILENAME);

   // Hole einzelne ACEs aus ACL
   AuthorizationRuleCollection ACEs = objFS.GetAccessRules(true, true, typeof(System.Security.Principal.NTAccount));

   // Schleife über alle ACEs
   foreach (FileSystemAccessRule ACE in ACEs)
   {
    Console.WriteLine("Benutzer/Gruppe {0}: {1} {2} ({3})",
     ACE.IdentityReference.ToString(),
     ACE.FileSystemRights,
     ACE.AccessControlType == AccessControlType.Allow ? "zugelassen" : "verweigert",
     ACE.IsInherited ? "vererbt" : "explizit"
     );
   }
  }

  // Hinzufügen eines ACE
  public static void Hinzufuegen()
  {

   const string FILENAME = @"d:\test\test.txt";

   // Hole ACL
   FileSecurity objFS = File.GetAccessControl(FILENAME);

   // ACE erzeugen
   FileSystemAccessRule rule = new FileSystemAccessRule(
   new System.Security.Principal.NTAccount(@"wetter\ar"), FileSystemRights.Read,
   AccessControlType.Allow);

   // Regel hinzufügen
   objFS.AddAccessRule(rule);

   // Speichern
   File.SetAccessControl(FILENAME, objFS);
  }
 }
}

