﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using System.Net.NetworkInformation;
using System.Net;
using System.Threading;
using de.ITVisions.DemoViewer;
using System.IO;


namespace N2C.FCL
{

 [de.ITVisions.DemoViewer.Demo]
 public class Netzwerk
 {

  // Herunterladen einer Datei per FTP
  public void FTPDownload()
  {
   FtpWebRequest request = (FtpWebRequest)WebRequest.Create("ftp://myftpserver/dir1/dir2/test.htmf");

   request.Credentials = new NetworkCredential("username", "pass");

   WebResponse response = request.GetResponse();

   Stream stream = response.GetResponseStream();


   StreamReader sr = new StreamReader(stream, Encoding.ASCII);
   string ss = sr.ReadToEnd();

  }

  // Heraufladen einer Datei per FTP

  public void FTPUpload()
  {
   // --- Request erstellen
   FtpWebRequest ftp = (FtpWebRequest)WebRequest.Create("ftp://www.WorldWideWings.de/test");
   ftp.Credentials = new NetworkCredential("user", "kennwort");
   //ftp.Method = FtpMethods.UploadFile;
   ftp.Timeout = System.Threading.Timeout.Infinite;
   Stream requestStream = ftp.GetRequestStream();

   Console.WriteLine("Sende Datei...");

   // --- Kopieren des Inhalts aus der Datei
   const int bufferLength = 2048;
   byte[] buffer = new byte[bufferLength];
   int count = 0;
   int readBytes = 0;
   FileStream stream = File.OpenRead(@"d:\temp\Flugdaten.xml");
   do
   {
    readBytes = stream.Read(buffer, 0, bufferLength);
    requestStream.Write(buffer, 0, bufferLength);
    count += readBytes;
   }
  while (readBytes != 0);

   // --- Antworten holen
   FtpWebResponse response = (FtpWebResponse)ftp.GetResponse();
   Console.WriteLine("Status: {0}", response.StatusCode);

   response.Close();
  }

  // Ping ausführen
  public void Ping()
  {
   const string COMPUTER = "www.IT-Visions.de";
   // Ping synchron ausführen
   Ping p = new Ping();
   PingReply pr = p.Send(COMPUTER);
   Console.WriteLine(pr.Status + ";" + pr.RoundtripTime);
   // Ping asynchron ausführen
   p.PingCompleted += new PingCompletedEventHandler(p_PingCompleted);
   p.SendAsync("Duisburg", null);
  }
  // Callsback für Ping
  static void p_PingCompleted(object sender, PingCompletedEventArgs e)
  {
   Console.WriteLine(e.Reply.Status + ";" + e.Reply.RoundtripTime + "ms");
  }

  public void NetStatus()
  {
   NetworkInterface[] adapters = NetworkInterface.GetAllNetworkInterfaces();
   foreach (NetworkInterface n in adapters)
   {
    Console.WriteLine("Netzwerkstatus:  {0} = {1}", n.Name, n.OperationalStatus);
   }
  }
  public void NetStatusWarten()
  {
   NetStatus();
   NetworkChange.NetworkAvailabilityChanged += new NetworkAvailabilityChangedEventHandler(NetworkChange_NetworkAvailabilityChanged);
   Console.WriteLine("Überwachung...");
   Console.ReadLine();
  }

  void NetworkChange_NetworkAvailabilityChanged(object sender, NetworkAvailabilityEventArgs e)
  {
   NetStatus();
  }


  // Statistische Daten aus dem TCP/IP-Protokollstack
  public void NetStatistik()
  {
   IPGlobalProperties ipgp = IPGlobalProperties.GetIPGlobalProperties();
   TcpStatistics t = ipgp.GetTcpIPv4Statistics();

   Console.WriteLine(t.CurrentConnections);
   Console.WriteLine(t.ErrorsReceived);
   Console.WriteLine(t.MaximumConnections);
   Console.WriteLine(t.SegmentsReceived);
   Console.WriteLine(t.SegmentsSent);
   Console.ReadLine();
  }

  // Absenden einer HTTP-Anfrage
  public void HTTP_Anfrage()
  {
   const string URL = "http://www.it-visions.de";
   // Anfrage definieren
   HttpWebRequest frage = (HttpWebRequest)HttpWebRequest.Create(URL);
   // Antwort holen
   HttpWebResponse antwort = (HttpWebResponse)frage.GetResponse();
   // Meta-Daten
   Demo.Print("Antwortlänge: " + antwort.ContentLength);
   Demo.Print("Status: " + antwort.StatusCode);
   Demo.Print("Letzte Änderung: " + antwort.LastModified);
   Demo.Print("Inhaltstyp: " + antwort.ContentType);
   // Inhalt ausgeben
   StreamReader sr = new StreamReader(antwort.GetResponseStream());
   Demo.Print(sr.ReadToEnd());
  }

  // FTP Download
  public static bool DisplayFileFromServer()
  {

   Uri serverUri = new Uri(@"ftp://ff44.s6.domainkunden.de/~db/extranet.mdb");
   // The serverUri parameter should start with the ftp:// scheme.
   if (serverUri.Scheme != Uri.UriSchemeFtp)
   {
    return false;
   }
   // Get the object used to communicate with the server.
   WebClient request = new WebClient();

   // This example assumes the FTP site uses anonymous logon.
   request.Credentials = new NetworkCredential("FF44", "xb3472868");
   try
   {
    byte[] newFileData = request.DownloadData(serverUri.ToString());
    string fileString = System.Text.Encoding.UTF8.GetString(newFileData);
    Console.WriteLine(fileString);
   }
   catch (WebException e)
   {
    Console.WriteLine(e.ToString());
   }
   return true;
  }

 }


 public class FtpState
 {
  private ManualResetEvent wait;
  private FtpWebRequest request;
  private string fileName;
  private Exception operationException = null;
  string status;

  public FtpState()
  {
   wait = new ManualResetEvent(false);
  }

  public ManualResetEvent OperationComplete
  {
   get { return wait; }
  }

  public FtpWebRequest Request
  {
   get { return request; }
   set { request = value; }
  }

  public string FileName
  {
   get { return fileName; }
   set { fileName = value; }
  }
  public Exception OperationException
  {
   get { return operationException; }
   set { operationException = value; }
  }
  public string StatusDescription
  {
   get { return status; }
   set { status = value; }
  }
 }

 [Demo]
 public class AsynchronousFtpUpLoader
 {
  // Command line arguments are two strings:
  // 1. The url that is the name of the file being uploaded to the server.
  // 2. The name of the file on the local machine.
  //
  public void Start()
  {
   // Create a Uri instance with the specified URI string.
   // If the URI is not correctly formed, the Uri constructor
   // will throw an exception.
   ManualResetEvent waitObject;

   Uri target = new Uri(@"ftp://ff44.s6.domainkunden.de/~db/extranet.mdb");
   string fileName = @"M:\ITVWEB\~db\extranet.mdb";
   FtpState state = new FtpState();
   FtpWebRequest request = (FtpWebRequest)WebRequest.Create(target);
   //request.Method = FtpMethods.UploadFile;

   // This example uses anonymous logon.
   // The request is anonymous by default; the credential does not have to be specified. 
   // The example specifies the credential only to
   // control how actions are logged on the server.

   request.Credentials = new NetworkCredential("FF44", "xb3472868");

   // Store the request in the object that we pass into the
   // asynchronous operations.
   state.Request = request;
   state.FileName = fileName;

   // Get the event to wait on.
   waitObject = state.OperationComplete;

   // Asynchronously get the stream for the file contents.
   request.BeginGetRequestStream(
       new AsyncCallback(EndGetStreamCallback),
       state
   );

   // Block the current thread until all operations are complete.
   waitObject.WaitOne();

   // The operations either completed or threw an exception.
   if (state.OperationException != null)
   {
    throw state.OperationException;
   }
   else
   {
    Console.WriteLine("The operation completed - {0}", state.StatusDescription);
   }
  }
  private static void EndGetStreamCallback(IAsyncResult ar)
  {
   FtpState state = (FtpState)ar.AsyncState;

   Stream requestStream = null;
   // End the asynchronous call to get the request stream.
   try
   {
    requestStream = state.Request.EndGetRequestStream(ar);
    // Copy the file contents to the request stream.
    const int bufferLength = 2048;
    byte[] buffer = new byte[bufferLength];
    int count = 0;
    int readBytes = 0;
    FileStream stream = File.OpenRead(state.FileName);
    do
    {
     readBytes = stream.Read(buffer, 0, bufferLength);
     requestStream.Write(buffer, 0, bufferLength);
     count += readBytes;
    }
    while (readBytes != 0);
    Console.WriteLine("Writing {0} bytes to the stream.", count);
    // IMPORTANT: Close the request stream before sending the request.
    requestStream.Close();
    // Asynchronously get the response to the upload request.
    state.Request.BeginGetResponse(
        new AsyncCallback(EndGetResponseCallback),
        state
    );
   }
   // Return exceptions to the main application thread.
   catch (Exception e)
   {
    Console.WriteLine("Could not get the request stream.");
    state.OperationException = e;
    state.OperationComplete.Set();
    return;
   }

  }

  // The EndGetResponseCallback method  
  // completes a call to BeginGetResponse.
  private static void EndGetResponseCallback(IAsyncResult ar)
  {
   FtpState state = (FtpState)ar.AsyncState;
   FtpWebResponse response = null;
   try
   {
    response = (FtpWebResponse)state.Request.EndGetResponse(ar);
    response.Close();
    state.StatusDescription = response.StatusDescription;
    // Signal the main application thread that 
    // the operation is complete.
    state.OperationComplete.Set();
   }
   // Return exceptions to the main application thread.
   catch (Exception e)
   {
    Console.WriteLine("Error getting response.");
    state.OperationException = e;
    state.OperationComplete.Set();
   }
  }
 }
}



