using System;
using System.IO;
using System.Threading;
using System.Diagnostics;
using System.Windows.Forms;
using de.ITVisions.DemoViewer;

namespace N2C.FCL
{

 [Demo]
 public class Ereignisprotokolle
 {


  public void Ereignisprotokoll_Auflisten()
  {
   // Liste der Ereignisprotokolle auf einem bestimmten Computer
   string computer = "Essen";

   Demo.Print("Liste der EventLogs auf dem Computer " + computer);
   EventLog[] liste = EventLog.GetEventLogs(computer);

   foreach (EventLog e in liste)
    Demo.Print(e.Log);
  }


  // Erzeugung eines neuen Eintrags in einem Ereignisprotokoll
  public void EreignisprotokollEintrag_Schreiben()
  {

   string logname = "N2C-B5";
   string source = "N2C-StartStop5";
   string computer = "Essen";
   // Quelle und ggf. Ereignisprotokoll anlegen
   if (!EventLog.SourceExists(source, computer))
   {
    EventSourceCreationData escd = new EventSourceCreationData(source, logname);
    escd.MachineName = computer;
    escd.LogName = logname;
    EventLog.CreateEventSource(escd);
    Demo.Print("Quelle angelegt!");
   }
   // Eintrag schreiben
   EventLog.WriteEntry(source, "Anwendung gestartet", EventLogEntryType.Information, 1234);
   // Bildschirmausgabe
   Demo.Print("Eintrag geschrieben!");
  }


  // Auslesen von Eintrgen aus einem Ereignisprotokoll
  public void EreignisprotokollEintraege_Lesen()
  {
   // Name des Ereignisprotokolls
   string logname = "Application";
   // Anzahl der auszugebenden Eintrge
   long anzahl = 10;
   // Zhler
   long count = 0;
   // -- Zugriff auf das Ereignisprotokoll
   EventLog log = new EventLog(logname);

   Demo.Print("Letzte " + anzahl.ToString() + " Eintrge von " + log.Entries.Count +
       " Eintrgen aus dem Protokoll " + log.Log + " auf dem Computer " + log.MachineName);

   // Schleife ber alle Eintrge
   foreach (EventLogEntry eintrag in log.Entries)
   {
    count += 1;
    if (count > log.Entries.Count - anzahl)
    {
     Demo.Print(eintrag.EntryType + ":" +
         eintrag.InstanceId + ":" +
         eintrag.Category + ":" +
         eintrag.Message + ":" +
         eintrag.Source + ":" +
         eintrag.TimeGenerated + ":" +
         eintrag.TimeWritten + ":" +
         eintrag.UserName + ":");
    }
   }
  }

  public void Ereignisprotokoll_Loeschen()
  {

   // Lschen eines Ereignisprotokolls
   string logName = "Application";
   string computer = "Essen";

   // Protokoll lschen
   EventLog.Delete(logName, computer);
   Demo.Print("Log gelscht!");
  }

  public void EventLog_Watcher()
  {

   // berwachung eines Ereignisprotokolls
   // Instanziierung und Konfiguration
   EventLog log = new EventLog();
   log.Log = "Application";
   log.MachineName = "Essen";

   // Verbindung der Ereignisbehandlungsroutine
   log.EntryWritten += new EntryWrittenEventHandler(this.EventLog_NeuerEintrag);

   // Starten der berwachung
   log.EnableRaisingEvents = true;

   Thread.Sleep(5000);
   this.EreignisprotokollEintrag_Schreiben();

   // Warten auf Benutzeraktion
   MessageBox.Show("Klicken Sie hier, um die berwachung zu beenden!", "berwachung");
  }


  private void EventLog_NeuerEintrag(object source, EntryWrittenEventArgs e)
  {

   //  Ereignisbehandlungsroutine fr Event-Log-berwachung
   EventLogEntry eintrag = e.Entry;

   Demo.Print(eintrag.EntryType.ToString() + ":" +
       eintrag.EventID.ToString() + ":" +
       eintrag.Category + ":" +
       eintrag.Message + ":" +
       eintrag.Source + ":" +
       eintrag.TimeGenerated.ToShortTimeString() + ":" +
       eintrag.TimeWritten.ToShortTimeString() + ":" +
       eintrag.UserName);
  }
 }
}
