﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;

namespace ConsoleUI_CS
{
 class ConfigurationDemos
 {

  public void Config_Demo()
  {

   string MailServer = ConfigurationManager.AppSettings["Mailserver"];
   string WWWSQLDatenbank = ConfigurationManager.ConnectionStrings["WWWDatenbank_MSSQL"].ConnectionString;
   string WWWAccessDatenbank = ConfigurationManager.ConnectionStrings["WWWDatenbank_Access"].ConnectionString;
   Console.WriteLine("Mailserver: " + MailServer);
   Console.WriteLine("Verbindungszeichenfolge 1: " + WWWSQLDatenbank);
   Console.WriteLine("Verbindungszeichenfolge 2: " + WWWAccessDatenbank);

   // --- Liste aller Verbindungszeichenfolgen
   foreach (ConnectionStringSettings cset in ConfigurationManager.ConnectionStrings)
   {
    Console.WriteLine(cset.Name + " = " + cset.ConnectionString);
   }

   // --- Ändern einer Einstellung
   Configuration c = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
   ConfigurationSection aset = c.GetSection("appSettings");
   ConfigurationManager.AppSettings["Mailserver"] = "Bochum";
   c.Save(ConfigurationSaveMode.Full);
   Console.WriteLine("Mailserver nun: " + ConfigurationManager.AppSettings["Mailserver"]);

   // --- Zugriff auf machine.config
   Configuration mc = ConfigurationManager.OpenMachineConfiguration();
   Console.WriteLine("machine.config liegt hier: " + mc.FilePath);
   // --- Liste der Sektionen in der machine.config

   foreach (ConfigurationSection s in mc.Sections)
   {
    Console.WriteLine("Sektion: " + s.SectionInformation.Name);
    Console.WriteLine("   Schreibschutz?: " + s.SectionInformation.IsLocked);
    Console.WriteLine("   Verschlüsselt?: " + s.SectionInformation.IsProtected);
   }

  }

  public void Config_Verschlueseln()
  {

   Console.WriteLine("Zugriff auf Sektion...");
   Configuration c = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
   ConfigurationSection s = c.GetSection("connectionStrings");
   Console.WriteLine("   Name: " + s.SectionInformation.Name);
   Console.WriteLine("   Verschlüsselt?: " + s.SectionInformation.IsProtected);
   if (s.SectionInformation.IsProtected)
   {
    Console.WriteLine("Verschlüsseln...");
    s.SectionInformation.ProtectSection(ProtectedConfiguration.DataProtectionProviderName);
   }
   else
   {
    Console.WriteLine("Entschlüsseln...");
    s.SectionInformation.UnprotectSection();

   }
   c.Save();
   Console.WriteLine("Kontrolle...");
   Configuration c2 = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
   ConfigurationSection s2 = c2.GetSection("connectionStrings");
   Console.WriteLine("   Name: " + s2.SectionInformation.Name);
   Console.WriteLine("   Verschlüsselt?: " + s2.SectionInformation.IsProtected);
   Console.WriteLine("Nutzen...");
   string WWWAccessDatenbank = ConfigurationManager.ConnectionStrings["WWWDatenbank_MSSQL"].ConnectionString;
   Console.WriteLine("Verbindungszeichenfolge: " + WWWAccessDatenbank);
   Console.WriteLine("Fertig! :-)");
  }

  public void SettingsDemos()
  {

   ConsoleUI_CS.Properties.Settings s = new ConsoleUI_CS.Properties.Settings();
   s.AnzahlAufrufDiesesNutzers++;
   s.AnzahlProgrammAufrufe++;
   s.Save();


   Console.WriteLine("Anzahl Programmaufrufe aller Nutzers: " + s.AnzahlProgrammAufrufe.ToString());
   Console.WriteLine("Anzahl Programmaufrufe dieser Nutzer: " + s.AnzahlAufrufDiesesNutzers.ToString());

   Console.WriteLine("Hier liegt die benutzerspezifische Konfigurationsdatei: " + System.Windows.Forms.Application.LocalUserAppDataPath);
  }
 }
}
