﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================

using System;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.ITVisions.DemoViewer;

namespace NET2
{
 /// <summary>
 /// Summary description for ProviderEnum.
 /// </summary>
 
 public class ProviderStatistik
 {
  
  public static void run()
  {
	  Demo.PrintHeader("ProviderStatistik");

   const string CONNSTRING = @"Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=ITVWeb;Data Source=Marl";
   const string SQL = "Select *from FL_Fluege";
   const string SQL2 = "Select * from AllePassagiere";

   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   // Statistik aktivieren
   sqlConn.StatisticsEnabled = true;
   // Verbindung aufbauen
   sqlConn.Open();
   // Befehl ausführen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   SqlDataReader r = sqlCmd.ExecuteReader();
   Demo.ReadWithoutPrinting(r);
   r.Close();

   // Noch einen Befehl ausführen
   SqlCommand sqlCmd2 = sqlConn.CreateCommand();
   sqlCmd2.CommandText = SQL2;
   SqlDataReader r2 = sqlCmd.ExecuteReader();
   Demo.ReadWithoutPrinting(r2);
   r2.Close();

   // --- Hole Statistik
   System.Collections.IDictionary Stat = sqlConn.RetrieveStatistics();
   // --- Schleife über alle Einträge
   foreach (System.Collections.DictionaryEntry de in Stat)
   {
    Demo.Print(de.Key + " = " + de.Value);
   }
  }
 }
}