// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================

using System;
using System.Data;
using System.Data.Common;
using System.Data.Sql;
using de.ITVisions.DemoViewer;


namespace NET2
{
 /// <summary>
 /// Summary description for ProviderEnum.
 /// </summary>
 [Demo]
 public class ProviderEnum
 {
  
  public void GetAllProviders()
  {
   Demo.PrintHeader("DEMO Providerliste");
   // --- Ermittlung der Provider
   DataTable providers = System.Data.Common.DbProviderFactories.GetFactoryClasses();
   // --- Ausgabe 
   foreach (DataRow provider in providers.Rows)
   {
    foreach (DataColumn c in providers.Columns)
     Console.WriteLine(c.ColumnName + ":" + provider[c]);
    Console.WriteLine("--");
   }
  }

  // Fehler in Beta 1
  public void GetAllSQLServers()
  {
	  DataTable t = DbProviderFactories.GetFactoryClasses();
   foreach (DataRow r in
     DbProviderFactories.GetFactoryClasses().Rows)
   {
    DbProviderFactory factory = DbProviderFactories.GetFactory(r);
    DbDataSourceEnumerator e =
       factory.CreateDataSourceEnumerator();
    if (e != null)
    {
     DataTable servers = e.GetDataSources();
     Demo.PrintTable(servers);
    }
   }
  }

  // Auflistung aller MS SQL-Server in der Domne
  
  public static void GetAllSQLServers2()
  {
	  Demo.PrintHeader("DEMO SQL Server im Netz:");
	  DataTable servers = SqlDataSourceEnumerator.Instance.GetDataSources();
   foreach (DataRow src in servers.Rows)
    Demo.PrintTable(servers);
  }



 }


}

