﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

//The SqlNotificationRequest/SqlDependency's SELECT statement must follow the rules for statements that can be used in SQL Server Indexed Views. This is because the NotificationRequest architecture uses the same mechanism as indexed views to deduce when a row in a resultset has changed. Here are  the rules for indexed views:
//
// The select list cannot use the * or table_name.* syntax to specify columns.  
// Column names must be explicitly stated. 
// Table names must be qualified with two part names. No 3 or 4 part names can be used. 
// A table column name used as a simple expression cannot be specified more than once. 
// No derived tables. 
// No rowset functions. 
// No UNION operator. 
// No subqueries. 
// No outer or self joins. 
// No TOP clause.  
// No DISTINCT keyword. 
// No COUNT(*) aggregate. 
// No AVG, MAX, MIN, STDEV, STDEVP, VAR, or VARP aggregates 
// No User Defined Aggregates 
// No SUM function that references a nullable expression 
// No full-text predicates that CONTAINS or FREETEXT. 
// No COMPUTE or COMPUTE BY clause 
// If GROUP BY is not specified, the select list cannot contain aggregate expressions 
// If GROUP BY is specified, the select list must contain a COUNT_BIG(*) expression, and cannot specify HAVING, CUBE, or ROLLUP 
// Must not reference table variables 
// Must not reference any other views or inlineable table-valued functions. 
// Must not reference any system tables or views 
// Must not reference any non-deterministic function – including ranking/windowing functions 
// Must not references any system session (@@) variables  
// Must reference some base table or view 
// No INTO clause 
// Must not specify FOR BROWSE (or be running with SET NO_BROWSETABLE ON) 
// No conditions that will preclude results from changing (e.g. WHERE 1=0) 
// Can not specify READPAST locking hint.  
// Must not reference any Service Broker QUEUE 
//
// 


// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================

using System;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.ITVisions.DemoViewer;

namespace NET2
{
 [Demo]
 public class Notfications_Demos
 {
  private static SqlDependency dep = null;

  static bool DataChanged = false;

  // === Warten auf Datenänderungen in der Flug-Tabelle
  public void run()
  {
   Demo.PrintHeader("Überwachung der Flugliste [Query Notifications]");

   string CONNSTRING2 = @"Integrated Security=SSPI;Database=WorldWideWings;Persist Security Info=True;Data Source=Marl\sqlexpress";
   const string SQL = "Select FL_FlugNr, FL_Zielort, Fl_Plaetze from dbo.FL_Fluege where FL_Abflugort = 'Frankfurt'";

   // Verbindung aufbauen
   SqlConnection conn = new SqlConnection(CONNSTRING2);
   conn.Open();

   while (true)
   {
    DataChanged = false;
    // Befehl definieren
    SqlCommand cmd = new SqlCommand(SQL, conn);

    // Überwachung anlegen
    dep = new SqlDependency(cmd);

    // Ereignisbehandlung binden
    dep.OnChange += new OnChangeEventHandler(dep_OnChange);

    // Befehl ausführen
    SqlDataReader r = cmd.ExecuteReader();
    Demo.PrintReader(r);

    while (!DataChanged)
    { System.Threading.Thread.Sleep(1000); Console.Write("."); }
   }
  }

  // Ereignisbehandlung für geänderte Daten
  static void dep_OnChange(object sender, SqlNotificationEventArgs e)
  {
   if (e.Type == SqlNotificationType.Subscribe)
   {
    Demo.Print("Fehler: " + e.Info.ToString());
   }
   else
   {
   Console.BackgroundColor = ConsoleColor.Cyan;
   Demo.Print("\nDaten haben sich geändert!");
   Console.BackgroundColor = ConsoleColor.Black;
   Demo.Print("Typ: " + e.Type.ToString());
   Demo.Print("Quelle: " + e.Source.ToString());
   Demo.Print("Info: " + e.Info.ToString());
   DataChanged = true;
   }
  }
 }

}