﻿using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;

namespace N2C.ADONET
{
 [Demo]
 class DataSetDemos_Schreiben
 {

  // === Daten schreiben mit einem DataSet
  public void DataSet_Schreiben()
  {
   Demo.PrintHeader("DataSet: Daten ändern");

   const string CONNSTRING = @"Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=WorldWideWings;Data Source=MARL\sqlexpress";
   const string SQL = "Select * from FL_Fluege";

   // --- Verbindung aufbauen
   SqlConnection conn = new SqlConnection(CONNSTRING);
   conn.Open();
   // --- Befehl ausführen
   SqlCommand cmd = new SqlCommand(SQL, conn);
   // --- Datenadapter erzeugen
   SqlDataAdapter da = new SqlDataAdapter(cmd);
   // --- DataSet erzeugen
   DataSet ds = new DataSet();
   // --- Daten abholen
   da.Fill(ds);
   // --- Verbindung jetzt schon schließen!
   conn.Close();

   DataTable dt = ds.Tables[0];

   // --- Datensätze löschen
   foreach (DataRow dr2 in dt.Rows)
   {
    if (dr2["FL_AbflugOrt"].ToString() == "Essen/Mülheim")
    {
     Demo.Print("Lösche: " + dr2["FL_FlugNr"]);
     dr2.Delete();
    }
   }

   // --- Datensätze ändern
   foreach (DataRow dr2 in dt.Rows)
   {
    if (dr2.RowState != DataRowState.Deleted)
    {
     dr2["FL_AnzahlStarts"] = Convert.ToInt32(dr2["FL_AnzahlStarts"]) + 1;
     Demo.Print("Counter erhöht für: " + dr2["FL_FlugNr"]);
    }
   }

   // --- Datensätz anfügen
   DataRow dr = dt.NewRow();
   dr["FL_FlugNr"] = "123";
   dr["FL_AnzahlStarts"] = 0;
   dr["FL_EingerichtetAm"] = DateTime.Now;
   dr["FL_Abflugort"] = "Essen/Mülheim";
   dr["FL_Zielort"] = "Eichstätt";
   dt.Rows.Add(dr);

   // --- Statistik
   if (ds.HasChanges(DataRowState.Added)) 
    Demo.Print("Anzahl der hinzugefügten Datensätze: " + 
     dt.GetChanges(DataRowState.Added).Rows.Count);
   if (ds.HasChanges(DataRowState.Modified)) 
    Demo.Print("Anzahl der geänderten Datensätze: " + 
     dt.GetChanges(DataRowState.Modified).Rows.Count);
   if (ds.HasChanges(DataRowState.Deleted)) 
    Demo.Print("Anzahl der gelöschten Datensätze: " + 
     dt.GetChanges(DataRowState.Deleted).Rows.Count);
   
    // --- Befehle für Datenadapter erzeugen
   SqlCommandBuilder cb = new SqlCommandBuilder(da);
   // --- Kontrollausgabe
   Demo.Print("Erzeugte SQL DML-Befehle:");
   Demo.Print("UPDATE: " + cb.GetUpdateCommand().CommandText);
   Demo.Print("DELETE: " + cb.GetDeleteCommand().CommandText);
   Demo.Print("INSERT: " + cb.GetInsertCommand().CommandText);

   // --- Aktualisieren
   da.Update(ds.Tables[0]);
   Demo.Print("Daten wurden aktualisiert!");

 
  }

 
 }
}
