<%@ page language="C#" masterpagefile="~/Master/itv.master" %>
<%@ register tagprefix="uc1" tagname="ObjectDetails" src="~/_controls/ObjectDetails.ascx" %>
<script runat="server" language="c#">

 
 void Page_Load(object sender, System.EventArgs e)
 {
     MembershipUser u = Membership.GetUser(this.User.Identity.Name);
     if (u != null)
     {
         C_Rollen.DataSource = Roles.GetRolesForUser(u.UserName);
         C_Rollen.DataBind();
     }

     if (!Page.IsPostBack) C_Theme.Items.FindByText(this.Theme).Selected = true;
 }
 
  
 void C_Theme_SelectedIndexChanged(object sender, System.EventArgs e)
 {
  Profile.Layout.Theme = C_Theme.SelectedValue;  
  Profile.Adresse.Postleitzahl = 45257; 
  this.Response.Redirect(this.Request.RawUrl, true);
  }
  
 
 void Page_PreInit(object sender, System.EventArgs e)
 {
  this.Theme = Profile.Layout.Theme;
 }
 
</script>
<asp:content id="Content1" contentplaceholderid="P_MainContent" runat="server">
    <br />
 Sind sind Mitglied in folgenden Rollen:<br />
 <asp:bulletedlist id="C_Rollen" runat="server">
 </asp:bulletedlist>
    <br />
 
 Ihr persnliches Layout: <asp:dropdownlist id="C_Theme" runat="server" autopostback="true" onselectedindexchanged="C_Theme_SelectedIndexChanged">
 <asp:listitem>Standard</asp:listitem>
 <asp:listitem>Rot</asp:listitem>
 <asp:listitem>Gruen</asp:listitem>
 </asp:dropdownlist>
 

 <br />
</asp:content>

