Imports System
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts

Namespace Microsoft.Sample.WebParts

    Public Class TextDisplayWebPart : Inherits System.Web.UI.WebControls.WebParts.WebPart : Implements IWebEditable

        ' Constructor
        Public Sub New()

            Me.AllowClose = False
            Me.Title = "Text Display Web Part"
        End Sub

        ' Fields - Private
        Private _ContentText As String = "This Web Part Display Text in this area"
        Private _MaxLength As Integer = -1

        ' Properties
        <WebBrowsable()> _
        <Personalizable()> _
        Public Property ContentText() As String
            Get
                If (_MaxLength = -1) Then
                    Return _ContentText
                ElseIf (_MaxLength > 0) Then
                    Return _ContentText.Substring(0, _MaxLength)
                Else
                    Return (String.Empty)
                End If

            End Get
            Set(ByVal value As String)
                _ContentText = value
            End Set
        End Property

        <Personalizable(PersonalizationScope.Shared)> _
        Public Property MaxTextDisplayLength() As Integer
            Get
                Return _MaxLength
            End Get
            Set(ByVal value As Integer)
                _MaxLength = value
            End Set
        End Property

        Public Overrides Property AllowClose() As Boolean
            Get
                Return False
            End Get
            Set(ByVal value As Boolean)
            End Set
        End Property

        Public Overrides Property AllowMinimize() As Boolean
            Get
                Return False
            End Get
            Set(ByVal value As Boolean)
            End Set
        End Property

        ' Methods
        Protected Overrides Sub CreateChildControls()
            Controls.Clear()
            Dim DisplayContent As New Label
            DisplayContent.Text = Me.ContentText
            Me.Controls.Add(DisplayContent)
            ChildControlsCreated = True
        End Sub

        Public Overrides ReadOnly Property Verbs() As WebPartVerbCollection
            Get
                EnsureChildControls()
                Dim saveVerb As WebPartVerb = New WebPartVerb(New WebPartEventHandler(AddressOf SaveData))
                saveVerb.Text = "Save"
                Dim newVerbs(0) As WebPartVerb
                newVerbs(0) = saveVerb
                Dim wp As WebPartVerbCollection = New WebPartVerbCollection(MyBase.Verbs, newVerbs)
                Return wp
            End Get
        End Property

        Public Sub SaveData(ByVal sender As Object, ByVal args As WebPartEventArgs)

            EnsureChildControls()
            Me.Title = Me.Title + " Saved .."
        End Sub

        Function CreateEditorParts() As EditorPartCollection Implements IWebEditable.CreateEditorParts

            If (Me.WebPartManager.Personalization.Scope = PersonalizationScope.User AndAlso Me.IsShared = True) Then
                Return (New EditorPartCollection())
            Else
                Dim EditorPartCollection As New EditorPartCollection
                ' // Geht nicht mehr in Beta2....
                ' EditorPartCollection.Add(New Sample.WebParts.TextDisplayEditorPart())
                Return EditorPartCollection
            End If
        End Function

        ReadOnly Property WebBrowsableObject() As Object Implements IWebEditable.WebBrowsableObject

            Get
                Return Me
            End Get
        End Property

        <ConnectionConsumer("TextConsumer1", "Text Consumer")> _
        Public Sub GetItextProvider(ByVal myInterface As Sample.WebParts.ITextCommunication)

            If (Not myInterface Is Nothing) Then
                ContentText = myInterface.Text
            End If
        End Sub

    End Class
End Namespace
