Imports System
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts

Namespace Microsoft.Sample.WebParts

    Public Class TextDisplayEditorPart : Inherits EditorPart : Implements INamingContainer

        Dim PartPropertyValue As New TextBox

        Protected Overrides Sub CreateChildControls()

            Controls.Clear()

            ' Title section
            Dim PartTitle As New Label
            PartTitle.Text = "Text Display Property Editor"
            PartTitle.Font.Bold = True
            Me.Controls.Add(PartTitle)
            Dim PartLineBreaker As New Literal
            PartLineBreaker.Text = "<br/>"
            Me.Controls.Add(PartLineBreaker)

            ' Body
            Dim PartLineBreaker0 As New Literal()
            PartLineBreaker0.Text = "<br/>"
            Me.Controls.Add(PartLineBreaker0)

            Dim PartProperty As New Label
            PartProperty.Text = "Max length :"
            Me.Controls.Add(PartProperty)
            Dim PartLineBreaker2 As New Literal
            PartLineBreaker2.Text = "<br/>"
            Me.Controls.Add(PartLineBreaker2)
            Dim tp As TextDisplayWebPart = CType(WebPartToEdit, TextDisplayWebPart)
            ' PartPropertyValue.ID = tp.ContentText;
            PartPropertyValue.Text = tp.MaxTextDisplayLength.ToString()
            Me.Controls.Add(PartPropertyValue)

            ' Footer
            Dim PartLineBreaker3 As New Literal
            PartLineBreaker3.Text = "<br/>"
            Dim PartLineBreaker4 As New Literal
            PartLineBreaker4.Text = "<br/>"
            Me.Controls.Add(PartLineBreaker3)
            Me.Controls.Add(PartLineBreaker4)

            Dim PartFooter As New Label
            PartFooter.Text = "This property defines the Maximun Length for the text that will be displayed for this web part"
            PartFooter.Font.Italic = True
            Dim partFooterSize As FontUnit = New FontUnit(FontSize.Small)
            PartFooter.Font.Size = partFooterSize
            Me.Controls.Add(PartFooter)

            ChildControlsCreated = True
        End Sub

  Public Overrides Function ApplyChanges() As Boolean

   Dim tp As TextDisplayWebPart = CType(WebPartToEdit, TextDisplayWebPart)
   tp.MaxTextDisplayLength = Convert.ToInt32(PartPropertyValue.Text)
   Return True
  End Function

        Public Overrides Sub SyncChanges()

            Dim tp As TextDisplayWebPart = CType(WebPartToEdit, TextDisplayWebPart)
            tp.MaxTextDisplayLength = Convert.ToInt32(PartPropertyValue.Text)
        End Sub
    End Class
End Namespace