package com.innoq.webservices.secure;

import org.systinet.wasp.security.ws.IncomingValidator;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.Constants;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.SignatureConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;

/**
 * Validator berprft, ob Nachricht mit einem
 * UsernameToken signiert wurde.
 */
public class MessageSignedValidator implements IncomingValidator {
  public void validate(MessageConf messageConf)
          throws WSSecurityException {
    SignatureConf[] signs =
            messageConf.getSignatures();
    if (signs!=null) {
      for (int i=0; i<signs.length; i++) {
        SignatureConf sign = signs[i];
        if (Boolean.TRUE.equals(sign.getSignBody())) {
          String tokenId =
               sign.getKeyInfo().getSecurityTokenId();
          SecurityTokenConf[] tokens =
                  messageConf.getSecurityTokens();
          for (int j = 0; j < tokens.length; j++) {
            SecurityTokenConf token = tokens[j];
            if (tokenId.equals(token.getWsuId())) {
              if (Constants.ST_VALUE_TYPE_USERNAME.
                      equals(token.getType())) {
                return;
              }
            }
          }
        }
      }
    }
    throw WSSecurityException.INVALID_SECURITY;
  }
}
