using System;
using Microsoft.Web.Services2;
using Microsoft.Web.Services2.Security;
using Microsoft.Web.Services2.Security.Tokens;
using Microsoft.Web.Services2.Security.X509;

namespace DefaultNamespace
{
	class MainClass
	{
		public static void Main(string[] args)
		{
			KreditkartenService service = new KreditkartenService();
            KreditkartenInfo info = new KreditkartenInfo();
            info.name="Ludger Springmann";
            info.nummer = "4711";
            info.gueltigVon = new DateTime(2000, 1, 1);
            info.gueltigBis = new DateTime(2004, 12, 31, 23, 59, 59);
			
			// Client benutzt UserToken
			UsernameToken userToken = 
				new UsernameToken("WSETEST", "wsetest", 
				                  PasswordOption.SendPlainText);
			SoapContext context = service.RequestSoapContext;
			context.Security.Tokens.Add(userToken);
			MessageSignature ms = new MessageSignature(userToken);
			context.Security.Elements.Add(ms);
			X509SecurityToken serverToken = GetServerX509Token();
			EncryptedData ed = new EncryptedData(serverToken);
			context.Security.Elements.Add(ed);
			EncryptedData ed2 = new EncryptedData(serverToken, string.Format("#{0}", userToken.Id));
			context.Security.Elements.Add(ed2);

            Boolean result = service.belasteKreditkarte(info, 10000, "EUR");
            if (result) {
                Console.WriteLine(
                        "Kreditkarte wurde akzeptiert und belastet!");
            } else {
                Console.WriteLine(
                        "Kreditkarte wurde abgelehnt!");
            }
		}

		public static X509SecurityToken GetServerX509Token() {
			X509CertificateStore store = X509CertificateStore.CurrentUserStore(X509CertificateStore.OtherPeople);
			store.OpenRead();
			X509CertificateCollection certs = 
				store.FindCertificateBySubjectName(
				        "CN=WSE2QuickStartServer"); 
//			X509CertificateCollection certs = store.FindCertificateByKeyIdentifier(Convert.FromBase64String("bBwPfItvKp3b6TNDq+14qs58VJQ="));
			store.Close();
			return new X509SecurityToken(((X509Certificate)certs[0]));
		}

	}
}
