package com.innoq.webservices.secure;

import java.util.Date;

/**
 * Class: KreditkartenService
 * Date:  01.07.2004
 */
public class KreditkartenService {
    /**
     * Belastet die Kreditkarte, die durch die
     * KreditkartenInfo definiert ist, um den
     * gegebenen Betrag in der gegebenen Whrung.
     * Liefert true wenn die Kreditkarte akzeptiert
     * wird, false sonst.
     */
    public boolean belasteKreditkarte(
            KreditkartenInfo pKreditkartenInfo,
            double pBetrag,
            String pWaehrung) {
        // Normalerweise luft hier eine Menge
        // Businesslogik ab. Um das zu vereinfachen
        // wird hier nur die Gltigkeit der Kreditkarte
        // abgefragt.
        Date current = new Date();
        if ((current.after(pKreditkartenInfo.gueltigVon) ||
                current.equals(pKreditkartenInfo.gueltigVon)) &&
                  (current.before(pKreditkartenInfo.gueltigBis) ||
                    current.equals(pKreditkartenInfo.gueltigBis))) {
            System.out.println("Kreditkarte gltig!");
            return true;
        }
        System.out.println("Kreditkarte ungltig!");
        return false;
    }
}
