package com.innoq.webservices.client;

import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.LookupException;
import com.innoq.webservices.client.structure.KreditkartenInfo;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class Client {
    public static final String WSDL =
            "http://localhost:6060/KreditkartenService/wsdl";

    public static void main(String[] args) {
        try {
            KreditkartenService service =
                    (KreditkartenService) Registry.lookup(WSDL,
                            KreditkartenService.class);
            KreditkartenInfo info = new KreditkartenInfo();
            info.name="Ludger Springmann";
            info.nummer = "4711";
            Calendar calendar = new GregorianCalendar();
            calendar.set(2000, 0, 1);
            info.gueltigVon = calendar.getTime();
            calendar.clear();
            calendar.set(2003, 11, 31, 23, 59, 59);
            info.gueltigBis = calendar.getTime();

            boolean result = service.belasteKreditkarte(info, 10000, "EUR");
            if (result) {
                System.out.println(
                        "Kreditkarte wurde akzeptiert und belastet!");
            } else {
                System.out.println(
                        "Kreditkarte wurde abgelehnt!");
            }
        } catch (LookupException e) {
            e.printStackTrace();
        }
    }
}
