using System;
using System.Net;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml.Serialization;
using Microsoft.Web.Services2;
using Microsoft.Web.Services2.Security.Tokens;


namespace innoQ {
 namespace WebServices {
  namespace Secure {
   public class KreditkartenService {

    /**
     * Belastet die Kreditkarte, die durch die
     * KreditkartenInfo definiert ist, um den
     * gegebenen Betrag in der gegebenen Whrung.
     * Liefert true wenn die Kreditkarte akzeptiert
     * wird, false sonst.
     */			 
	 [WebMethod]
	 public Boolean belasteKreditkarte(
	            KreditkartenInfo pKreditkartenInfo,
	            Double pBetrag,
	            String pWaehrung) {
		checkUser(RequestSoapContext.Current);	            	
        // Normalerweise luft hier eine Menge
        // Businesslogik ab. Um das zu vereinfachen
        // wird hier nur die Gltigkeit der Kreditkarte
        // abgefragt.
        DateTime heute = DateTime.Now;
        if (heute.CompareTo(pKreditkartenInfo.gueltigVon)>=0 &&
            heute.CompareTo(pKreditkartenInfo.gueltigBis)<=0) {
            Console.WriteLine("Kreditkarte gltig!");
            return true;
        }
        Console.WriteLine("Kreditkarte ungltig!");
        return false;
     }
     
     private void checkUser(SoapContext context) {
		if (context == null)
		   throw new Exception(
               "Nur SOAP Requests erlaubt!");

		// Make sure there's a token
		if (context.Security.Tokens.Count == 0)
		{
		   throw new SoapException(
		      "Kein SecurityToken gefunden!", 
 		      SoapException.ClientFaultCode);
		}
		else
		{
		   foreach (UsernameToken tok in 
		            context.Security.Tokens) {
		      if (tok.Principal.IsInRole(
		                string.Format("{0}\\WSE_TEST",
						Dns.GetHostName()))) {
		      	return;
		      } else {
		      	throw new Exception("User hat falsche Rolle!" + tok);
		      }
		   }
		   throw new Exception(
		       "Kein UsernameToken gefunden!");
		}
     }
	}
	
	
	public class KreditkartenInfo {
	    public string nummer;
	    public string name;
	    public DateTime gueltigVon;
	    public DateTime gueltigBis;
	}
  }
 }
}
