package com.innoq.webservices.client;

import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.Wasp;
import org.idoox.security.Credentials;
import org.idoox.wasp.WaspSecurity;
import org.idoox.wasp.WaspInternalException;
import com.innoq.webservices.client.structure.KreditkartenInfo;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.security.NoSuchProviderException;

/**
 * Class: SecureClient
 * Date:  05.07.2004
 */
public class SecureClient {

    public static final String WSDL =
            "http://localhost:6060/KreditkartenService/wsdl";

    public static void main(String[] args) {
        try {
            // Security programmatisch
            Wasp.init();
            Credentials credentials = WaspSecurity.acquireClientCredentials("test", "test", "WS-Security");
            ServiceClient serviceClient = ServiceClient.create();
            WaspSecurity.setCredentials(serviceClient, new Credentials[]{credentials});
            serviceClient.setWSDLLocation(WSDL);
            WaspSecurity.setInitiatingProvider(serviceClient, "WS-Security");
            KreditkartenService service =
                    (KreditkartenService) serviceClient.createProxy(KreditkartenService.class);


            KreditkartenInfo info = new KreditkartenInfo();
            info.name="Ludger Springmann";
            info.nummer = "4711";
            Calendar calendar = new GregorianCalendar();
            calendar.set(2000, 0, 1);
            info.gueltigVon = calendar.getTime();
            calendar.clear();
            calendar.set(2003, 11, 31, 23, 59, 59);
            info.gueltigBis = calendar.getTime();

            boolean result = service.belasteKreditkarte(info, 10000, "EUR");
            if (result) {
                System.out.println(
                        "Kreditkarte wurde akzeptiert und belastet!");
            } else {
                System.out.println(
                        "Kreditkarte wurde abgelehnt!");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
