/*
 * AuthorDetector.java
 *
 * Copyright (c) 2003 Peter Friese
 * All rights reserved.
 *  
 */
package de.heise.ix.builders.scanner;

/**
 * The class AuthorDetector is responsible for ...
 * TODO Enter purpose of class, please!
 * 
 * @author Peter Friese
 */
public class AuthorDetector extends BaseDetector {
	
	public static final String NAME = "author";
	
	private static final String CONTRIBUTOR_LABEL = "@author";
	private static final int CONTRIBUTOR_LABEL_LEN = CONTRIBUTOR_LABEL.length();

	/**
	 * @see de.heise.ix.builders.scanner.BaseDetector#getDetectorName()
	 */
	public String getDetectorName() {
		return NAME;
	}

	/**
	 * @see de.heise.ix.builders.scanner.BaseDetector#detect(java.lang.String)
	 */
	public void detect(String line) {
		int contributorPos = line.lastIndexOf(CONTRIBUTOR_LABEL);
		if (contributorPos >= 0) {
			String contributor = line.substring(contributorPos + CONTRIBUTOR_LABEL_LEN);
			String contributorFormatted = 
				(contributor != null)
					? contributor.trim()
					: "";
					
			if (!resultCollection.contains(contributorFormatted)) {
				resultCollection.add(contributorFormatted);
			}
		}
	}

}
