/*
 * NatureManager.java
 *
 * Copyright (c) 2003 Peter Friese
 * All rights reserved.
 *  
 */
package de.heise.ix.builders.nature;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

import de.heise.ix.builders.ContributorsMarker;

/**
 * The class NatureManager is responsible for ...
 * TODO Enter purpose of class, please!
 * 
 * @author Peter Friese
 */
public class NatureManager {
	
	private Shell shell;

	private IProject project;

	public NatureManager(Shell shell, IProject project) {
		this.shell = shell;
		this.project = project;
	}
	
	/**
	 * Using the natures name, check whether the current
	 * project has the given nature.
	 * 
	 * @return boolean <code>true</code>, if the nature is
	 *   assigned to the project, <code>false</code> otherwise.
	 */
	public boolean isNatureEnabled() {
		boolean result = false;

		try {
			if (this.project.hasNature(ContributorsNature.NATURE_ID))
				result = true;
		} 
		catch (CoreException e) {
			System.err.println("Exception: " + e);
		}
		return result;
	}	
	
	/**
	 * Add the nature to the current project. The real work is 
	 * done by the inner class NatureWorker
	 * @return boolean <code>true</code> if the nature could
	 *   be added successfully, <code>false</code> otherwise.
	 */
	public boolean addNature() {
		boolean result = true;
		try {
			NatureWorker worker = new NatureWorker(true);
			ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.shell);
			monitor.run(true, true, worker);
		} 
		catch (InvocationTargetException e) {
			System.err.println("Exception: " + e);
		} 
		catch (InterruptedException e) {
			System.err.println("Exception: " + e);
		}
		return result;
	}
	
	/**
	 * Remove the nature from the project.
	 * @return boolean <code>true</code> if the nature could
	 *   be added successfully, <code>false</code> otherwise.
	 */
	public boolean removeNature() {
		boolean result = true;
		try {
			// remove any markers added by our builder
			this.project.deleteMarkers(ContributorsMarker.NAME, true, IResource.DEPTH_INFINITE);
			
			NatureWorker worker = new NatureWorker(false);
			ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.shell);
			monitor.run(true, true, worker);
		} 
		catch (InvocationTargetException e) {
			System.err.println("Exception: " + e);
		} 
		catch (InterruptedException e) {
			System.err.println("Exception: " + e);
		} catch (CoreException e) {
			System.err.println("Exception: " + e);
		}
		return result;
				
	}
	
	private class NatureWorker implements IRunnableWithProgress {
		
		private boolean add = true;
		
		public NatureWorker(boolean add) {
			this.add = add;
		}
		
		/**
		 * @see IRunnableWithProgress#run(IProgressMonitor)
		 */
		public void run(IProgressMonitor monitor)
			throws InvocationTargetException, InterruptedException {
			try {
				if (add) {
					addFindBugsNature(project, monitor);
				}
				else {
					removeFindBugsNature(project, monitor);
				}
			}
			catch (CoreException e) {
				e.printStackTrace();
				System.err.println("Exception: " + e);
			}
		}
		
		/**
		 * Adds a FindBugs nature to a project.
		 * 
		 * @param project The project the nature will be applied to.
		 * @param monitor A progress monitor. Must not be null.
		 * @throws CoreException
		 */
		public void addFindBugsNature(IProject project, IProgressMonitor monitor) throws CoreException {
			if (!project.hasNature(ContributorsNature.NATURE_ID)) {
				IProjectDescription description = project.getDescription();
				String[] prevNatures = description.getNatureIds();
				String[] newNatures = new String[prevNatures.length + 1];
				System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
				newNatures[prevNatures.length] = ContributorsNature.NATURE_ID;
				for (int i = 0; i < newNatures.length; i++) {
					System.out.println(newNatures[i]);
				}
				description.setNatureIds(newNatures);
				project.setDescription(description, monitor);
			}
			else {
				monitor.worked(1);
			}
		}

		/**
		 * Removes the FindBugs nature from a project.
		 * 
		 * @param project The project the nature will be removed from.
		 * @param monitor A progress monitor. Must not be null.
		 * @throws CoreException
		 */
		public void removeFindBugsNature(
			IProject project,
			IProgressMonitor monitor)
			throws CoreException {
			if (project.hasNature(ContributorsNature.NATURE_ID)) {
				IProjectDescription description = project.getDescription();
				String[] prevNatures = description.getNatureIds();

				ArrayList newNaturesList = new ArrayList();

				for (int i = 0; i < prevNatures.length; i++)
					if (!prevNatures[i].equals(ContributorsNature.NATURE_ID)) {
						newNaturesList.add(prevNatures[i]);
					}

				String[] newNatures = new String[newNaturesList.size()];
				for (int i = 0; i < newNaturesList.size(); i++)
					newNatures[i] = (String) newNaturesList.get(i);

				description.setNatureIds(newNatures);
				project.setDescription(description, monitor);
			}
			else {
				monitor.worked(1);
			}

		}
		
	}

}
