using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Microsoft.Office.Interop.Excel;
using de.iX.Reisekosten.GL;

namespace  iX_Reisekosten_Web
{
	/// <summary>
	/// Zusammenfassung fr GetExcel.
	/// </summary>
	public class GetExcel : System.Web.UI.Page
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			Session["User"] = "HS"; // TEST

		Mitarbeiter m = new Mitarbeiter(Session["User"].ToString());


		// Excel starten im Hintergrund
		Microsoft.Office.Interop.Excel.Application ex = new Microsoft.Office.Interop.Excel.ApplicationClass();
		
			// Vorlage ffnen
			string filename = Server.MapPath("Vorlage/ix_Reisekosten_Excel.xls");
			Microsoft.Office.Interop.Excel.Workbook w = ex.Workbooks.Add(filename);
		Microsoft.Office.Interop.Excel.Worksheet s = (Microsoft.Office.Interop.Excel.Worksheet) w.ActiveSheet;
		
			/// Befllen
			SetCell(s, "B5",m.Name);
		SetCell(s, "B6",m.Personalnummer.ToString());
			SetCell(s, "B7",m.Kostenstelle.ToString());
			
			// Speichern unter neuem Name
			filename = Server.MapPath("Vorlage/ix_Reisekosten_" + m.UserID + ".xls");
			w.SaveCopyAs(filename);

			// Excel beenden
			w.Close(false,null,null);
			ex.Quit();
		
			// Verknpfung zu VSTO-DLL setzen
			OfficeToolkitPersistenceLib.OfficeToolkitPersistenceClass otp = new OfficeToolkitPersistenceLib.OfficeToolkitPersistenceClass();
			otp.SetAssemblyLocation(filename,@"http://hagen/ix_Reisekosten_Web/VSTOComponents/");
			otp.SetAssemblyName(filename,"Reisekosten_Excel.dll");
			
			// Browser zum erstellten Dokument lenken
			Response.Redirect(filename);
		}

		protected void SetCell(Worksheet s, string Cell, string Value)
		{
			Range range = s.get_Range(Cell,Cell);
			range.Value2 = Value;
		}

		protected string GetCell(Worksheet s, string Cell )
		{
			Range range = s.get_Range(Cell,Cell);
			return range.Value2.ToString();
		}

		#region Vom Web Form-Designer generierter Code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: Dieser Aufruf ist fr den ASP.NET Web Form-Designer erforderlich.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
