Imports System.Windows.Forms
Imports Office = Microsoft.Office.Core
Imports Excel = Microsoft.Office.Interop.Excel
Imports MSForms = Microsoft.Vbe.Interop.Forms
Imports Word = Microsoft.Office.Interop.Word
' Office integration attribute. Identifies the startup class for the workbook. Do not modify.
<Assembly: System.ComponentModel.DescriptionAttribute("OfficeStartupClass, Version=1.0, Class=ix_Reisekosten_Excel2.OfficeCodeBehind")>

Public Class OfficeCodeBehind 

    Friend WithEvents ThisWorkbook As Excel.Workbook
    Friend WithEvents ThisApplication As Excel.Application

#Region "Generated initialization code"

    ' Default constructor.
    Public Sub New()
    End Sub

    ' Required procedure. Do not modify.
    Public Sub _Startup(ByVal application As Object, ByVal workbook As Object)
        ThisApplication = CType(application, Excel.Application)
        ThisWorkbook = CType(workbook, Excel.Workbook)

    
    End Sub

    ' Required procedure. Do not modify.
    Public Sub _Shutdown()
        ThisApplication = Nothing
        ThisWorkbook = Nothing
    End Sub

    ' Returns the control with the specified name on ThisWorkbook's active worksheet.
    Overloads Function FindControl(ByVal name As String) As Object
        Return FindControl(name, CType(ThisWorkbook.ActiveSheet, Excel.Worksheet))
    End Function

    ' Returns the control with the specified name on the specified worksheet.
    Overloads Function FindControl(ByVal name As String, ByVal sheet As Excel.Worksheet) As Object
        Dim theObject As Excel.OLEObject
        Try
            theObject = CType(sheet.OLEObjects(name), Excel.OLEObject)
            Return theObject.Object
        Catch Ex As Exception
            ' Returns Nothing if the control is not found.
        End Try
        Return Nothing
    End Function
#End Region

    ' Called when the workbook is opened.
    Private Sub ThisWorkbook_Open() Handles ThisWorkbook.Open



    End Sub

    ' Called before the workbook is closed. Note that this method
    ' might be called multiple times and the value assigned to Cancel
    ' might be ignored if other code or the user intervenes.
    ' Cancel is False when the event occurs. If the event procedure
    ' sets this to True, the document does not close when the procedure is finished.
    Private Sub ThisWorkbook_BeforeClose(ByRef Cancel As Boolean) Handles ThisWorkbook.BeforeClose
        Cancel = False
    End Sub

    ' === Ereignisbehandlung fr Hyperlink
    Private Sub LinkClick(ByVal Sh As Object, ByVal Target As Microsoft.Office.Interop.Excel.Hyperlink) Handles ThisApplication.SheetFollowHyperlink
        Dim abr As New de.ix.Reisekostenabrechnung
        abr = ErstelleAbrechnungsObjekt()
        Dim id As System.Guid = AbrechnungVersenden(abr)
        ErgebnisAusgeben(abr, id)
        QuittungErzeugen(abr, id)
    End Sub

    ' === Prfung der Eingaben
    Private Function ErstelleAbrechnungsObjekt() As de.ix.Reisekostenabrechnung

        Dim s As Excel.Worksheet = Me.ThisWorkbook.ActiveSheet()
        Me.ThisApplication.StatusBar = "Abrechnung wird ausgewertet..."
        ' === Stammdaten einlesen
        Dim abr As New de.ix.Reisekostenabrechnung
        abr.MitarbeiterName = s.Cells(5, 2).Value
        abr.Personalnummer = s.Cells(6, 2).Value
        abr.Kostenstelle = s.Cells(7, 2).Value
        ' === Reisegrundaten
        abr.ReiseGrund = s.Cells(11, 2).Value
        abr.Beginn = DateTime.Parse(s.Cells(12, 2).Value)
        abr.Ende = DateTime.Parse(s.Cells(13, 2).Value)
        ' === Reisedetails 
        abr.Positionen = New ArrayList
        For zeile As Integer = 17 To 27
            If Convert.ToDouble(s.Cells(zeile, 2).value) <> 0 Then
                Dim pos As New de.ix.ReisekostenPosition
                pos.Text = Convert.ToString(s.Cells(zeile, 1).value)
                pos.Betrag = Convert.ToDouble(s.Cells(zeile, 2).value)
                pos.Bemerkung = Convert.ToString(s.Cells(zeile, 3).value)
                abr.Summe += pos.Betrag
                abr.Positionen.Add(pos)
            End If
        Next
        Return abr

    End Function

    ' === Einreichen des Formulars an den Webservice
    Private Function AbrechnungVersenden(ByVal abr As de.ix.Reisekostenabrechnung)
        Dim ws As New de.ix.ReisekostenService
        Dim s As Excel.Worksheet = Me.ThisWorkbook.ActiveSheet()
        Me.ThisApplication.StatusBar = "Abrechnung wird eingereicht fuer: " & abr.MitarbeiterName
        Dim id As System.Guid = ws.ReisekostenAbrechnungEinreichen(abr)
        Return id
    End Function

    ' === Ausgaben in Excel-Dokument
    Private Sub ErgebnisAusgeben(ByVal abr As de.ix.Reisekostenabrechnung, ByVal id As System.Guid)
        Dim s As Excel.Worksheet = Me.ThisWorkbook.ActiveSheet()
        s.Cells(28, 2) = abr.Summe
        s.Cells(30, 1).Value = "Eingereicht am: " & System.DateTime.Now
        s.Cells(31, 1).Value = "Besttigungscode: " & id.ToString
        Me.ThisApplication.StatusBar = "Abrechnung wurde eingereicht fuer: " & abr.MitarbeiterName
        MsgBox("Abrechnung wurde gespeichert unter der Nr. " & id.ToString, MsgBoxStyle.Information, "Reisekostenabrechnung")
    End Sub

    ' === Ausgaben in Word-Dokument
    Private Sub QuittungErzeugen(ByVal abr As de.ix.Reisekostenabrechnung, ByVal id As System.Guid)

        Me.ThisApplication.StatusBar = "Quittung wird gedruckt..."

        Dim wordapp As New Word.Application
        wordapp.Visible = True
        Dim doc As Word.Document
        doc = wordapp.Documents.Add

        With wordapp
            .Selection.Font.Name = "Arial"
            .Selection.Font.Size = 10
            .Selection.TypeText(Text:="iX-Redaktion")
            .Selection.TypeParagraph()
            .Selection.Font.Size = 18
            .Selection.TypeText(Text:="Quittung fr Reisekostenbermittlung")
            .Selection.TypeParagraph()
            .Selection.MoveUp(Word.WdUnits.wdLine, 1, 0)
            With .Selection.Borders(Word.WdBorderType.wdBorderBottom)
                .LineStyle = wordapp.Options.DefaultBorderLineStyle
                .LineWidth = wordapp.Options.DefaultBorderLineWidth
                .Color = wordapp.Options.DefaultBorderColor
            End With
            .Selection.MoveDown(Unit:=Word.WdUnits.wdLine, Count:=1)
            .Selection.Font.Size = 10
            .Selection.TypeParagraph()
            .Selection.TypeText(Text:= _
                "Folgende Reisekostenabrechnung wurde erfolgreich bermittelt")
            .Selection.TypeText(Text:=":")
            .Selection.TypeParagraph()
            .Selection.TypeText(Text:="Antragsteller: " & abr.MitarbeiterName)
            .Selection.TypeParagraph()
            .Selection.TypeText(Text:="Reisegrund: " & abr.ReiseGrund)
            .Selection.TypeParagraph()
            .Selection.TypeText(Text:="Summe: " & abr.Summe)
            .Selection.TypeParagraph()
            .Selection.TypeParagraph()
            .Selection.Font.Italic = True
            .Selection.TypeText(Text:="Eingereicht am: " & Now)
            .Selection.TypeParagraph()
            .Selection.TypeText(Text:="Besttigungscode: " & id.ToString)

        End With
        doc.PrintOut()
        wordapp.Quit()
        Me.ThisApplication.StatusBar = "Quittung wurde gedruckt fuer: " & id.ToString
            End Sub


End Class
