using System;
using System.Xml.Serialization;

namespace de.iX.Reisekosten.GL
{
	/// <summary>
	/// Zusammenfassung fr Class1.
	/// </summary>
	/// 
	[Serializable(), XmlInclude(typeof(ReisekostenPosition))] public class Reisekostenabrechnung
	{

		const string DATASTORE = @"d:\Daten\";
		const string SMTPSERVER = "Bochum";

		public string MitarbeiterName = "";
		public string ReiseGrund = "";
		public long Personalnummer = 0;
		public long Kostenstelle = 0;
		public System.DateTime Beginn;
		public System.DateTime Ende;
		public double Summe;

		public System.Collections.ArrayList Positionen = new System.Collections.ArrayList();

		public Reisekostenabrechnung()
		{
      
		}

		public static Reisekostenabrechnung GetByID(string GUID)
		{
		return (Reisekostenabrechnung) de.itv.SerializationHelper.Bin_Deserialize(DATASTORE + GUID.ToString() + ".xml");
		
		
		}

		public void NeuePosition(string Text, float Betrag)
		{
			ReisekostenPosition RKP = new ReisekostenPosition();
			RKP.Text = Text;
			RKP.Betrag = Betrag;
			Positionen.Add(RKP);
		}

		public System.Guid SaveTemp()
		{
			// Eindeutige ID vergeben
			System.Guid guid = System.Guid.NewGuid();
			// Hier bergabe an Zwischenspeicher!
			de.itv.SerializationHelper.Xml_Serialize(this,DATASTORE + guid.ToString() + ".xml");
			// E-Mail an Vorgesetzen
			string Inhalt = "";
			Inhalt += "Folgende Reisekostenabrechnung wurde eingereicht:\n";
			Inhalt += "Antragsteller: " + this.MitarbeiterName + "\n";
			Inhalt += "Reisegrund: " + this.ReiseGrund + "\n";
			Inhalt += "Summe: " + this.Summe + "\n";
			Inhalt += "Klicken Sie auf dne nachfolgenden Link, um den Antrag zu genehmigen!\n";
			Inhalt += "http://localhost/iX_Reisekosten_Web/Genehmigung.aspx?GUID=" + guid.ToString() + "\n";

			System.Web.Mail.SmtpMail.SmtpServer = SMTPSERVER;
			Mitarbeiter chef = new Mitarbeiter(this.Personalnummer).Vorgesetzer;
			System.Web.Mail.MailMessage m = new System.Web.Mail.MailMessage();
			m.From = "Reisekosten@ix.de";
			m.To = chef.EMail;
			m.Subject = "Reisekostengenehmigung";
			m.Body = Inhalt;
			System.Web.Mail.MailAttachment a = new System.Web.Mail.MailAttachment(DATASTORE + guid.ToString() + ".xml",System.Web.Mail.MailEncoding.Base64);
			m.Attachments.Add(a);
			//System.Web.Mail.SmtpMail.Send(m);
			// ID zurckgeben
			return guid;
		}

		public bool SaveFinal()
		{
			// Hier bergabe an Abrechnungssystem!
			return true;
		}
	}

	[Serializable()]
	public class ReisekostenPosition
	{
		public string Text;
		public float Betrag;
		public string Bemerkung;
	}

}