
Imports Office = Microsoft.Office.Core
Imports Excel = Microsoft.Office.Interop.Excel
Imports MSForms = Microsoft.Vbe.Interop.Forms
Imports Microsoft.Office.Interop.Excel

' Office-Integrationsattribut. Gibt die Startklasse fr die Arbeitsmappe an. Nicht ndern.
<Assembly: System.ComponentModel.DescriptionAttribute("OfficeStartupClass, Version=1.0, Class=FragebogenPruefer_DOTNET1.OfficeCodeBehind")>

Public Class OfficeCodeBehind 

    Friend WithEvents ThisWorkbook As Excel.Workbook
    Friend WithEvents ThisApplication As Excel.Application

#Region "Generierter Initialisierungscode"

    ' Standardkonstruktor.
    Public Sub New()
    End Sub

    ' Erforderliche Prozedur. Nicht ndern.
    Public Sub _Startup(ByVal application As Object, ByVal workbook As Object)
        ThisApplication = CType(application, Excel.Application)
        ThisWorkbook = CType(workbook, Excel.Workbook)

    
    End Sub

    ' Erforderliche Prozedur. Nicht ndern.
    Public Sub _Shutdown()
        ThisApplication = Nothing
        ThisWorkbook = Nothing
    End Sub

    ' Gibt das Steuerelement mit dem angegebenen Namen auf der aktiven Arbeitsmappe von 'ThisWorkbook' zurck.
    Overloads Function FindControl(ByVal name As String) As Object
        Return FindControl(name, CType(ThisWorkbook.ActiveSheet, Excel.Worksheet))
    End Function

    ' Gibt das Steuerelement mit dem angegebenen Namen auf der angegebenen Arbeitsmappe zurck.
    Overloads Function FindControl(ByVal name As String, ByVal sheet As Excel.Worksheet) As Object
        Dim theObject As Excel.OLEObject
        Try
            theObject = CType(sheet.OLEObjects(name), Excel.OLEObject)
            Return theObject.Object
        Catch Ex As Exception
            ' Gibt 'Nothing' zurck, wenn das Steuerelement nicht gefunden wurde.
        End Try
        Return Nothing
    End Function
#End Region

    ' Aufruf erfolgt beim ffnen der Arbeitsmappe.
  Private Sub ThisWorkbook_Open() Handles ThisWorkbook.Open
    If MsgBox("Prfung starten?", vbYesNo) = vbYes Then Pruefung()
  End Sub

  ' Wird vor dem Schlieen der Arbeitsmappe aufgerufen. Diese Methode kann
  ' mehrmals aufgerufen werden, und der zu 'Cancel' zugewiesene Wert
  ' kann ignoriert werden, falls anderer Code oder der Benutzer eingreift.
  ' 'Cancel' ist 'False' wenn das Ereignis eintritt. Falls der Ereignisvorgang
  ' dies als 'True' festlegt, wird das Dokument am Ende des Vorgangs nicht geschlossen.
  Private Sub ThisWorkbook_BeforeClose(ByRef Cancel As Boolean) Handles ThisWorkbook.BeforeClose
    'If MsgBox("Prfung starten?", vbYesNo) = vbYes Then
    '  If Not Pruefung() Then ' Wenn Fehler, dann nicht schlieen!
    '    Cancel = True
    '    MsgBox("Es gibt Fehler in dieser Datei!")
    '  End If
    'End If
  End Sub


  ' ////// Prfung der Fragebgen
  Function Pruefung() As Boolean
    Const PE_SHEETNAME = "Prfungsergebnis"
    Pruefung = True ' Standardrckgabewert
    Dim TBs As Sheets
    Dim TB As Worksheet
    TBs = ThisWorkbook.Sheets
    ' === 1. Wenn es schon ein Prfungsergebnis gibt, dann lsche das Tabellenblatt
    On Error Resume Next
    TB = TBs.Item(PE_SHEETNAME)
    On Error GoTo 0
    If Not TB Is Nothing Then TB.Delete()
    ' === 2. Tabellenblatt fr Prfungsergebnis anfgen
    Dim PE As Worksheet
    PE = ThisApplication.Sheets.Add
    PE.Name = PE_SHEETNAME
    ' === 3. Inhalt des Tabellenblatts festlegen
    PE.Cells(1, 1) = "Prfungsvorgang vom " & Now
    PE.Cells(2, 1) = "Tabellenblatt"
    PE.Cells(2, 2) = "Zeile"
    PE.Cells(2, 3) = "Fehler"
    ThisApplication.Range("A1:A1").Font.Size = 14
    ThisApplication.Range("A2:C2").Select()
    With ThisApplication.Selection.Interior
      .ColorIndex = 4
      .Pattern = Excel.Constants.xlSolid
    End With
    ' Erste beschreibare Zeile auf Ergebnisseite setzen
    Dim PE_Zeile As Long
    PE_Zeile = 2

    ' 4. === Schleife fr alle zu prfenden Tabellenbltter
    For Each TB In TBs

      If TB.Name <> PE_SHEETNAME Then
        Dim Zeile As Byte
        For Zeile = 1 To 4
         
          If TB.Cells(Zeile, 2).Value Is Nothing Then
            PE_Zeile = PE_Zeile + 1
            PE.Cells(PE_Zeile, 1).Value = TB.Name
            PE.Cells(PE_Zeile, 2).Value = Replace(TB.Cells(Zeile, 1).Value, ":", "")
            PE.Cells(PE_Zeile, 3).Value = "Angabe fehlt"
            Pruefung = False
          End If
        Next
      End If
    Next
  End Function

End Class
