package de.wartala.ant.tasks;

import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class NewsGroupList extends DataType {
	private Vector newsgroups = new Vector();
	private String newsgroup;

	public NewsGroupList() {
		super();
	}

	protected NewsGroupList(NewsGroupList newsgroups) {
		this.newsgroup = newsgroups.newsgroup;
		this.newsgroups = newsgroups.newsgroups;
		setProject(newsgroups.getProject());
	}

	public void setRefid(Reference r) throws BuildException {
		if ((newsgroup != null) || (newsgroups.size() != 0)) {
			throw tooManyAttributes();
		}
		super.setRefid(r);
	}

	public void setNewsGroup(String newsgroup) throws BuildException {
		if (isReference()) {
			throw tooManyAttributes();
		}
		this.newsgroup = newsgroup;
	}

	public String getNewsGroup(Project p) {
		if (isReference()) {
			return getRef(p).getNewsGroup(p);
		}
		return newsgroup;
	}

	public void setNewsgroups(String newsgroups) {
		if (isReference()) {
			throw tooManyAttributes();
		}
		if (newsgroups != null && newsgroups.length() > 0) {
			StringTokenizer tok = new StringTokenizer(newsgroups, ", \t\n\r\f", false);
			while (tok.hasMoreTokens()) {
				String token = (String) tok.nextToken();
				this.newsgroups.addElement(token);
			}
		}
	}

	public String[] getNewsGroups(Project p) {
		if (isReference()) {
			return getRef(p).getNewsGroups(p);
		}

		if (newsgroups == null) {
			throw new BuildException("No newsgroups specified for newsgrouplist.");
		}

		if (newsgroups.size() == 0) {
			throw new BuildException("No newsgroups specified for newsgrouplist.");
		}

		String[] result = new String[newsgroups.size()];
		newsgroups.copyInto(result);
		return result;
	}

	protected NewsGroupList getRef(Project p) {
		if (!checked) {
			Stack stk = new Stack();
			stk.push(this);
			dieOnCircularReference(stk, p);
		}

		Object o = ref.getReferencedObject(p);
		if (!(o instanceof NewsGroupList)) {
			String msg = ref.getRefId() + " doesn\'t denote a newsgrouplist";
			throw new BuildException(msg);
		} else {
			return (NewsGroupList) o;
		}
	}
}

