/*
 * Created on 20.09.2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package de.wartala.ant.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

import org.apache.commons.net.nntp.ArticlePointer;
import org.apache.commons.net.nntp.NNTPClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author Ramon Wartala
 *
 */
public class NNTPClientTask extends Task {
	private String newsServer;
	private int maxArticles;
	private File outputDir;
	private int serverPort;
	private String extName;
	private NewsGroupList newsgroups;
	private NNTPClient newsClient;

	/**
	 * @see org.apache.tools.ant.Task#init()
	 */
	public void init() throws BuildException {
		this.newsClient = new NNTPClient();
		this.serverPort = 119;
		this.extName = "news";
		this.newsServer = "news.t-online.com";
		this.newsgroups = new NewsGroupList();
		this.maxArticles = 10;
	}

	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException {
		if (this.getNewsServer() == null) {
			throw new BuildException("error: You must specify the news server host name!");
		}

		if (this.getServerPort() == 0) {
			throw new BuildException("error: You must specify a port number for the server!");
		}

		try {
			System.out.println("server is " + this.getNewsServer());
			System.out.println("port is " + this.getServerPort());
			newsClient.connect(this.getNewsServer(), this.getServerPort());

			boolean status = true;
			String body = null;
			int newsIndex = 0;
			FileWriter fw = null;
			String[] targetNewsgroups = this.newsgroups.getNewsGroups(this.getProject());
			for (int i = 0; i < targetNewsgroups.length; i++) {
				System.out.print("retrieve " + targetNewsgroups[i]+"...");
				status = newsClient.selectNewsgroup(targetNewsgroups[i]);
				if (status) {
					newsIndex++;
					ArticlePointer ap = getFirstArticle(newsClient.getReplyString());
					int firstArticle = ap.articleNumber;
					body = getArticleBody(newsClient.retrieveArticleBody());
					fw = new FileWriter(this.getOutputDir().getAbsolutePath()+System.getProperty("file.separator")+this.getExtName()+"_"+newsIndex+".txt");
					fw.write(body);
					fw.close();
					while (newsClient.selectNextArticle(ap) && newsIndex < maxArticles) {
						body = getArticleBody(newsClient.retrieveArticleBody());
						fw = new FileWriter(this.getOutputDir().getAbsolutePath()+System.getProperty("file.separator")+this.getExtName()+"_"+newsIndex+".txt");
						fw.write(body);
						fw.close();
						newsIndex++;
					}
				} else {
					System.out.println("not available");
				}
			}
			System.out.println("OK");
			newsClient.logout();
			newsClient.disconnect();
		} catch (IOException e) {
			throw new BuildException("error while connecting the news server!");
		}

	}

	/**
	 * @return
	 */
	public NewsGroupList createNewsgroups() {
		if (this.newsgroups == null) {
			this.newsgroups = new NewsGroupList();
		}
		return newsgroups;
	}

	/**
	 * @param newsgroups
	 */
	public void setNewsGroups(String newsgroups) {
		this.newsgroups.setNewsgroups(newsgroups);
	}

	/**
	 * @param newsgroup
	 */
	public void addNewsGroup(String newsgroup) {
		this.newsgroups.setNewsGroup(newsgroup);
	}

	/**
	 * @return
	 */
	public String getNewsServer() {
		return newsServer;
	}

	/**
	 * @return
	 */
	public File getOutputDir() {
		return outputDir;
	}

	/**
	 * @return
	 */
	public int getServerPort() {
		return serverPort;
	}

	/**
	 * @param string
	 */
	public void setNewsServer(String string) {
		newsServer = string;
	}

	/**
	 * @param file
	 */
	public void setOutputDir(String dirName) {
		outputDir = new File(dirName);
	}

	/**
	 * @param i
	 */
	public void setServerPort(int i) {
		serverPort = i;
	}

	/**
	 * @param reader
	 * @return
	 */
	private String getArticleSubject(Reader reader) {
		StringBuffer sb = new StringBuffer();
		try {
			BufferedReader br = new BufferedReader(reader);
			String line = br.readLine();
			while (line != null) {
				if (line.indexOf("Subject:") != -1) {
					return line.substring(line.indexOf(':') + 1);
				}
				line = br.readLine();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * @param reader
	 * @return
	 */
	private String getArticleBody(Reader reader) {
		StringBuffer sb = new StringBuffer();
		try {
			BufferedReader br = new BufferedReader(reader);
			String line = br.readLine();
			while (line != null) {
				sb.append(line + "\n");
				line = br.readLine();
			}
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * @param replyString
	 * @return
	 */
	private ArticlePointer getFirstArticle(String replyString) {
		StringTokenizer st = new StringTokenizer(replyString);
		int status = Integer.parseInt(st.nextToken());
		if (status == 211) {
			int articleCount = Integer.parseInt(st.nextToken());
			int firstArticle = Integer.parseInt(st.nextToken());
			int lastArticle = Integer.parseInt(st.nextToken());
			String groupName = st.nextToken();
			ArticlePointer ap = new ArticlePointer();
			ap.articleNumber = firstArticle;
			return ap;
		}
		return null;
	}

	/**
	 * @return
	 */
	public String getExtName() {
		return extName;
	}

	/**
	 * @param string
	 */
	public void setExtName(String string) {
		extName = string;
	}

	/**
	 * @return
	 */
	public int getMaxArticles() {
		return maxArticles;
	}

	/**
	 * @param i
	 */
	public void setMaxArticles(int i) {
		maxArticles = i;
	}

}