/*
 * Decompiled with CFR 0.152.
 */
package de.wartala.ant.tasks;

import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class NewsGroupList
extends DataType {
    private Vector newsgroups = new Vector();
    private String newsgroup;

    public NewsGroupList() {
    }

    protected NewsGroupList(NewsGroupList newsgroups) {
        this.newsgroup = newsgroups.newsgroup;
        this.newsgroups = newsgroups.newsgroups;
        this.setProject(newsgroups.getProject());
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.newsgroup != null || this.newsgroups.size() != 0) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public void setNewsGroup(String newsgroup) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.newsgroup = newsgroup;
    }

    public String getNewsGroup(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getNewsGroup(p);
        }
        return this.newsgroup;
    }

    public void setNewsgroups(String newsgroups) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (newsgroups != null && newsgroups.length() > 0) {
            StringTokenizer tok = new StringTokenizer(newsgroups, ", \t\n\r\f", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                this.newsgroups.addElement(token);
            }
        }
    }

    public String[] getNewsGroups(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getNewsGroups(p);
        }
        if (this.newsgroups == null) {
            throw new BuildException("No newsgroups specified for newsgrouplist.");
        }
        if (this.newsgroups.size() == 0) {
            throw new BuildException("No newsgroups specified for newsgrouplist.");
        }
        Object[] result = new String[this.newsgroups.size()];
        this.newsgroups.copyInto(result);
        return result;
    }

    protected NewsGroupList getRef(Project p) {
        Object o;
        if (!this.checked) {
            Stack<NewsGroupList> stk = new Stack<NewsGroupList>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        if (!((o = this.ref.getReferencedObject(p)) instanceof NewsGroupList)) {
            String msg = String.valueOf(this.ref.getRefId()) + " doesn't denote a newsgrouplist";
            throw new BuildException(msg);
        }
        return (NewsGroupList)((Object)o);
    }
}

