/*
 * Decompiled with CFR 0.152.
 */
package de.wartala.ant.tasks;

import de.wartala.ant.tasks.NewsGroupList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import org.apache.commons.net.nntp.ArticlePointer;
import org.apache.commons.net.nntp.NNTPClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class NNTPClientTask
extends Task {
    private String newsServer;
    private int maxArticles;
    private File outputDir;
    private int serverPort;
    private String extName;
    private NewsGroupList newsgroups;
    private NNTPClient newsClient;

    public void init() throws BuildException {
        this.newsClient = new NNTPClient();
        this.serverPort = 119;
        this.extName = "news";
        this.newsServer = "news.t-online.com";
        this.newsgroups = new NewsGroupList();
        this.maxArticles = 10;
    }

    public void execute() throws BuildException {
        if (this.getNewsServer() == null) {
            throw new BuildException("error: You must specify the news server host name!");
        }
        if (this.getServerPort() == 0) {
            throw new BuildException("error: You must specify a port number for the server!");
        }
        try {
            System.out.println("server is " + this.getNewsServer());
            System.out.println("port is " + this.getServerPort());
            this.newsClient.connect(this.getNewsServer(), this.getServerPort());
            boolean status = true;
            String body = null;
            int newsIndex = 0;
            FileWriter fw = null;
            String[] targetNewsgroups = this.newsgroups.getNewsGroups(this.getProject());
            int i = 0;
            while (i < targetNewsgroups.length) {
                System.out.print("retrieve " + targetNewsgroups[i] + "...");
                status = this.newsClient.selectNewsgroup(targetNewsgroups[i]);
                if (status) {
                    ArticlePointer ap = this.getFirstArticle(this.newsClient.getReplyString());
                    int firstArticle = ap.articleNumber;
                    body = this.getArticleBody(this.newsClient.retrieveArticleBody());
                    fw = new FileWriter(String.valueOf(this.getOutputDir().getAbsolutePath()) + System.getProperty("file.separator") + this.getExtName() + "_" + ++newsIndex + ".txt");
                    fw.write(body);
                    fw.close();
                    while (this.newsClient.selectNextArticle(ap) && newsIndex < this.maxArticles) {
                        body = this.getArticleBody(this.newsClient.retrieveArticleBody());
                        fw = new FileWriter(String.valueOf(this.getOutputDir().getAbsolutePath()) + System.getProperty("file.separator") + this.getExtName() + "_" + newsIndex + ".txt");
                        fw.write(body);
                        fw.close();
                        ++newsIndex;
                    }
                } else {
                    System.out.println("not available");
                }
                ++i;
            }
            System.out.println("OK");
            this.newsClient.logout();
            this.newsClient.disconnect();
        }
        catch (IOException e) {
            throw new BuildException("error while connecting the news server!");
        }
    }

    public NewsGroupList createNewsgroups() {
        if (this.newsgroups == null) {
            this.newsgroups = new NewsGroupList();
        }
        return this.newsgroups;
    }

    public void setNewsGroups(String newsgroups) {
        this.newsgroups.setNewsgroups(newsgroups);
    }

    public void addNewsGroup(String newsgroup) {
        this.newsgroups.setNewsGroup(newsgroup);
    }

    public String getNewsServer() {
        return this.newsServer;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setNewsServer(String string) {
        this.newsServer = string;
    }

    public void setOutputDir(String dirName) {
        this.outputDir = new File(dirName);
    }

    public void setServerPort(int i) {
        this.serverPort = i;
    }

    private String getArticleSubject(Reader reader) {
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(reader);
            String line = br.readLine();
            while (line != null) {
                if (line.indexOf("Subject:") != -1) {
                    return line.substring(line.indexOf(58) + 1);
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getArticleBody(Reader reader) {
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(reader);
            String line = br.readLine();
            while (line != null) {
                sb.append(String.valueOf(line) + "\n");
                line = br.readLine();
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArticlePointer getFirstArticle(String replyString) {
        StringTokenizer st = new StringTokenizer(replyString);
        int status = Integer.parseInt(st.nextToken());
        if (status == 211) {
            int articleCount = Integer.parseInt(st.nextToken());
            int firstArticle = Integer.parseInt(st.nextToken());
            int lastArticle = Integer.parseInt(st.nextToken());
            String groupName = st.nextToken();
            ArticlePointer ap = new ArticlePointer();
            ap.articleNumber = firstArticle;
            return ap;
        }
        return null;
    }

    public String getExtName() {
        return this.extName;
    }

    public void setExtName(String string) {
        this.extName = string;
    }

    public int getMaxArticles() {
        return this.maxArticles;
    }

    public void setMaxArticles(int i) {
        this.maxArticles = i;
    }
}

