namespace Delegates
{
	/// <summary>
	/// The status of the worker
	/// </summary>
	public enum EStatus
	{
		enmIdle,
		enmWorkStarted,
		enmWorkInProgress, 
		enmWorkCompleted
	}
	/// <summary>
	/// The Feedback a notified object can give about the progress of the work.
	/// </summary>
	public enum EFeedback
	{
		/// <summary>
		/// I don't care about the progress of your work
		/// </summary>
		enmNotInterested,
		/// <summary>
		/// The standard response of a boss about his workers progress
		/// </summary>
		enmTooSlow,
		/// <summary>
		/// The work progress is good.
		/// </summary>
		enmGreat, 
		/// <summary>
		/// The standard respons of a boss when a worker has finished.
		/// </summary>
		enmItsAboutTime 
	}
}