using System;

namespace Delegates
{
	/// <summary>
	/// The entry point for everything
	/// </summary>
	class CUniverse
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			//The bosses are born
			CBoss bill = new CBoss("Bill", "Gates", DateTime.Parse("12.07.1962"));
			CBoss gisella = new CBoss("Gisella", "Rader", DateTime.Parse("24.07.1971"));
			//The worker is born
			CWorker michael = new CWorker ("Michael", "Rader", DateTime.Parse("18.12.1969"));
			//The worker's dog is born
			CDog hasso = new CDog("Hasso", "Yorkshire Terrier");

			//The universe wants to know everything
			michael.progress = new ReportProgressHandler (CUniverse.ReportProgress);
			michael.status = new ReportStatusChangeHandler (CUniverse.ReportStatusChange);
			//bill wants to be notified about michaels work progress and status
			michael.progress = new ReportProgressHandler(bill.ReportProgress);
			michael.status = new ReportStatusChangeHandler(bill.ReportStatusChange);
			//gisella also wants to be notified about michaels work progress and status
			michael.progress = new ReportProgressHandler(gisella.ReportProgress);
			michael.status = new ReportStatusChangeHandler(gisella.ReportStatusChange);
			//michaels dog only cares about michaels status and not his progress
			michael.status = new ReportStatusChangeHandler(hasso.ReportStatusChange);
			michael.StartWork(); //Michael starts working

			//now look whats happening
			Console.ReadLine ();
		}
		private static void ReportStatusChange (CWorker sender, EStatus enmStatus)
		{
			Console.WriteLine ("The universe recognized a status change for {0} {1} to {2}",
				sender.FirstName, sender.LastName, enmStatus.ToString ());
		}
		private static EFeedback ReportProgress (CWorker sender, byte bytProgress)
		{
			Console.WriteLine ("The universe recognized the progress from {0} {1} 's work to {2} percent",
				sender.FirstName, sender.LastName, bytProgress);
			return EFeedback.enmNotInterested;
		}
	}
}
