using System;

namespace Delegates
{
	/// <summary>
	/// A Boss is a Person with the special ability to be notified about status and progress of work.
	/// To do this, it implements the ReportProgress and ShowStatus functions.
	/// </summary>
	public class CBoss : CPerson
	{
		#region ctors
		public CBoss():this("", "")
		{}
		public CBoss(string strFirstName, string strLastName):this(strFirstName, strLastName, DateTime.Today)
		{}
		public CBoss(string strFirstName, string strLastName, DateTime dtDateOfBirth):base(strFirstName, strLastName, dtDateOfBirth)
		{
		}
		#endregion
		/// <summary>
		/// Is called when a worker makes progress
		/// </summary>
		/// <param name="sender">The worker who has sent the progress update</param>
		/// <param name="bytProgress">The current progress of the work as "percentage completed"</param>
		/// <returns>The "satisfaction level" of the boss</returns>
		public EFeedback ReportProgress(CWorker sender, byte bytProgress)
		{  
			Console.WriteLine("{0} {1} has been notified that {2} has done {3} percent of his work", this.FirstName, this.LastName, sender.FirstName, bytProgress.ToString());
			if (bytProgress >40 && bytProgress <100)
				return EFeedback.enmTooSlow;
			if (bytProgress >=100)
				return EFeedback.enmItsAboutTime;
			else	
				return EFeedback.enmNotInterested;
		}
		/// <summary>
		/// Is called when a worker's status changes
		/// </summary>
		/// <param name="sender">The worker who has sent the status update</param>
		/// <param name="enmStatus">The worker's new status</param>
		public void ReportStatusChange(CWorker sender, EStatus enmStatus)
		{
			Console.WriteLine("{0} {1}, the boss, has been notified that the worker {2}'s status has changed to {3}\n", this.FirstName, this.LastName, sender.FirstName, enmStatus.ToString());
		}

	}
}
