using System;
using System.Security.Cryptography;
using System.IO;

namespace Samples 
{

	class CryptorAsym 
	{
		
		public static void Main(String[] args) 
		{
			
			if(args.Length != 4)
			{
				Console.WriteLine("Anwendung: CryptorAsym <Recipient> <Src> <Dest> encrypt|decrypt");
			}
			
			// Name des Kommunikationspartners
			String recipient = args[0];
			
			String srcFileName = args[1];
			String destFileName = args[2];
			bool bEncrypt = args[3].Equals("encrypt");
						
			byte[] salt = new byte[16];
			
			// Der Oeffentliche Schluessel des Kommunikationspartners wird gelesen und gesetzt
			RSACryptoServiceProvider rsaRecipient = new RSACryptoServiceProvider();
			String keyString = ReadKey(recipient);

			rsaRecipient.FromXmlString(keyString);
			
			// Der eigene private Schluessel wird gelesen und gesetzt
			RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
			keyString = ReadKey("private");

			rsa.FromXmlString(keyString);

			// Ein Rijndael Objekt wird erzeugt und enthaelt einen Zufaellig erzeugten Schluessel
			Rijndael rijndael = Rijndael.Create();
			
			// Wir oeffnen die Dateien zum Lesen und Schreiben
			FileStream fileOutputStream = File.Open(destFileName,FileMode.Create);
			
			FileStream fileInputStream = File.Open(srcFileName,FileMode.Open);
			
			if(bEncrypt)
			{
				// Falls wir verschluesseln, verschluesseln wir den Session Key und schreiben
				// ihn in die Zieldatei
				byte[] encryptedKey = rsaRecipient.Encrypt(rijndael.Key, false);
				fileOutputStream.Write(encryptedKey,0,128);
				// ansonsten erzeugen wir es mit dem Kryptographischen Zufallszahlengenerator
				RandomNumberGenerator random = RandomNumberGenerator.Create();
				random.GetBytes(salt);
				// Wir erzeugen aus unserem Algorithmus einen ICryptoTransform			
				HashAlgorithm hashAlgorithm = SHA1.Create();
				Stream inputStream;
				// Beim Verschluesseln wenden wir beim Lesen den Hashalgorithmus an
				inputStream = new CryptoStream(fileInputStream,hashAlgorithm,CryptoStreamMode.Read);
				// Wir lesen die Daten vom Stream
				byte[] content = readStream(inputStream);
				CryptoStream outputStream;
				// Falls wir verschluesseln, muessen wir zuerst Salz und InitialWert schreiben
				fileOutputStream.Write(salt,0,16);
				fileOutputStream.Write(rijndael.IV,0,16);
				// Dann setzen wir rijndael ein, um die daten zu Verschlsseln	
				outputStream = new CryptoStream(fileOutputStream,rijndael.CreateEncryptor(),CryptoStreamMode.Write);
				// Beim Entschlsseln schreiben wir die letzten 128 Byte nicht,
				// da sie die Signatur enthalten
				outputStream.Write(content,0,content.Length-(bEncrypt ? 0 : 128));
				// Falls wir verschlsseln, mssen wir den Hash unterzeichnen und
				//verschlsselt mit in die Datei schreiben	
				outputStream.Write(rsa.SignHash(hashAlgorithm.Hash,CryptoConfig.MapNameToOID("SHA1")),0,128);
				outputStream.FlushFinalBlock();
				outputStream.Close();
				Console.WriteLine("Datei geschrieben");
				fileOutputStream.Close();
				fileInputStream.Close();
			}
		}
		
		private static String ReadKey(String recipient)
		{
			StreamReader reader = new StreamReader(File.Open(recipient+"Key.xml",FileMode.Open));
			String keyString = reader.ReadLine();
			reader.Close();
			return keyString;
		}
		
		private static byte[] readStream(Stream stream)
		{
			byte[] content = null;
			byte[] temp = null;
			
			byte[] buffer = new byte[1024];
			
			int bytesRead;
			int length = 0;			
			
			while((bytesRead = stream.Read(buffer,0,1024))>0)
			{				
				temp = new byte[length + bytesRead];
				
				if(length > 0)
				{
					content.CopyTo(temp,0);
				}
				
				Array.Copy(buffer,0,temp,length,bytesRead);
				
				content = temp;
				length += bytesRead;
			} 
			stream.Close();
			return content;			
		}	
	}
	
	

}
