package de.wartala.eclipse.IpkDeploy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;

/**
 * 
 * @author Administrator
 */
public class IpkgStreamWriter {

	/**
	 * Method pushStream.
	 * @param in
	 * @param out
	 * @throws IOException
	 */
	static public void pushStream(InputStream in, OutputStream out) throws IOException {
		byte[] buffer = new byte[1023];
		while(true) {
	    int size = in.read(buffer);
	    if(size == -1) {
	    	break;
	    }
	    out.write(buffer,0,size);
		}
  }
  
	/**
	 * Method getMainClassName.
	 * @param JarFilename
	 * @return String
	 * @throws IOException
	 */
  static public String getMainClassName(String JarFilename) throws IOException {
  	File f = new File(JarFilename);
  	URL fu = f.toURL();
  	URL u = new URL("jar:"+fu.toExternalForm()+"!/");
		JarURLConnection uc = (JarURLConnection)u.openConnection();
		Attributes attr = uc.getMainAttributes();
		return attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
  }
}
