package de.wartala.eclipse.IpkDeploy;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class IpkDeployWizardPage extends WizardPage {
	
	final static String[] RESOURCE_FILTERS = new String[] {"*.jar","*.png"};
	
	// widgets
	private Button addRes;
	private Button removeRes;
	
	private Label projectNameLabel;
	private Label projectTypeLabel;
	private Label versionLabel;
	private Label descriptionLabel;
	private Label providerLabel;
	private Label providerMailLabel;
	private Label resourceLabel;
	private Label iconLabel;
	private Label mainClassLabel;
	
	private Combo typeCombo;
	private List resourceList;
	
	private Text projectNameText;
	private Text versionText;
	private Text descriptionText;
	private Text providerText;
	private Text providerMailText;
	private Text iconText;
	private Text mainClassText;
	
	private FileDialog addResFileDialog;
	
	// attributes
	private int selectedIndex;
	private String projectNameStr;
	private String projectTypeStr;
	private String versionStr;
	private String descriptionStr;
	private String providerStr;
	private String providerMailStr;
	private String iconStr;
	private String mainClassStr;
	
	private Properties classMap;
	
	/**
	 * @see java.lang.Object#Object()
	 */
	public IpkDeployWizardPage() {
		super("IPK Deploy", IpkDeployMessage.getString("WindowTitle"), null);	
		this.setDescription(IpkDeployMessage.getString("WizardDescription")); 
		this.selectedIndex = -1;
		this.projectNameStr = "";
		this.projectTypeStr = "";
		this.versionStr = "";
		this.descriptionStr = "";
		this.providerStr = "";
		this.providerMailStr = "";
		this.iconStr = "";
		this.mainClassStr = "";
		this.classMap = new Properties();
	}
	
	/**
	 * This method create the user interface widgets for the wizard page.
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		setControl(composite);
			
		Group projectGroup = new Group(composite,SWT.NONE);
		GridLayout projectGridLayout = new GridLayout();
 		projectGridLayout.numColumns = 2;
		projectGroup.setLayout(projectGridLayout);
		projectGroup.setText(IpkDeployMessage.getString("ProjectProperties")); 
		projectGroup.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
	
		Composite labelGroup = new Composite(projectGroup, SWT.NONE);
		GridLayout labelGroupLayout = new GridLayout();
		labelGroupLayout.numColumns = 1;
		labelGroup.setLayout(labelGroupLayout);
		GridData labelGroupData = new GridData(GridData.FILL_VERTICAL);
		labelGroupData.widthHint = 90;
		labelGroup.setLayoutData(labelGroupData);	
		projectNameLabel = new Label(labelGroup, SWT.HORIZONTAL);
		projectNameLabel.setText(IpkDeployMessage.getString("ProjectLabelText"));
		GridData projectNameData = new GridData(GridData.FILL_HORIZONTAL);
		projectNameData.widthHint = 75;
		projectNameData.heightHint = 20;
		projectNameLabel.setLayoutData(projectNameData);
		projectTypeLabel = new Label(labelGroup, SWT.HORIZONTAL);
	  projectTypeLabel.setText(IpkDeployMessage.getString("ProjectTypeLabelText"));
	  GridData projectTypeData = new GridData(GridData.FILL_HORIZONTAL);
	  projectTypeData.widthHint = 75;
		projectTypeData.heightHint = 20;
		projectTypeLabel.setLayoutData(projectTypeData);
		versionLabel = new Label(labelGroup, SWT.HORIZONTAL);
	  versionLabel.setText(IpkDeployMessage.getString("versionLabelText"));
	  GridData versionData = new GridData(GridData.FILL_HORIZONTAL);
	  versionData.widthHint = 75;
		versionData.heightHint = 20;
		versionLabel.setLayoutData(versionData);
		descriptionLabel = new Label(labelGroup, SWT.HORIZONTAL);
	  descriptionLabel.setText(IpkDeployMessage.getString("DescriptionLabelText"));
	  GridData descriptionData = new GridData(GridData.FILL_HORIZONTAL);
	  descriptionData.widthHint = 75;
		descriptionData.heightHint = 20;
		descriptionLabel.setLayoutData(descriptionData);
	  
	  providerLabel = new Label(labelGroup, SWT.HORIZONTAL);
	  providerLabel.setText(IpkDeployMessage.getString("ProviderLabelText"));
	  GridData providerData = new GridData(GridData.FILL_HORIZONTAL);
	  providerData.widthHint = 75;
		providerData.heightHint = 20;
		providerLabel.setLayoutData(providerData);
		
		providerMailLabel = new Label(labelGroup, SWT.HORIZONTAL);
	  providerMailLabel.setText(IpkDeployMessage.getString("ProviderMailLabelText"));
	  GridData providerMailData = new GridData(GridData.FILL_HORIZONTAL);
	  providerMailData.widthHint = 75;
		providerMailData.heightHint = 20;
		providerMailLabel.setLayoutData(providerMailData);
		
		
		
	 	iconLabel = new Label(labelGroup, SWT.HORIZONTAL);
	  iconLabel.setText(IpkDeployMessage.getString("IconLabelText"));
	  GridData iconData = new GridData(GridData.FILL_HORIZONTAL);
	  iconData.widthHint = 75;
		iconData.heightHint = 20;
		iconLabel.setLayoutData(iconData);
		mainClassLabel = new Label(labelGroup, SWT.HORIZONTAL);
	  mainClassLabel.setText(IpkDeployMessage.getString("MainLabelText"));
	  GridData mainClassData = new GridData(GridData.FILL_HORIZONTAL);
	  mainClassData.widthHint = 75;
		mainClassData.heightHint = 20;
		mainClassLabel.setLayoutData(mainClassData);  
	    
	  // All text input widgets
		Composite textGroup = new Composite(projectGroup, SWT.NONE);
		GridLayout textGroupLayout = new GridLayout();
		textGroupLayout.numColumns = 1;
		textGroup.setLayout(textGroupLayout);
		GridData textLayoutData = new GridData(GridData.FILL_BOTH); 
		textGroup.setLayoutData(textLayoutData);     	
		projectNameText = new Text(textGroup, SWT.SINGLE | SWT.BORDER);
		GridData projectTextData = new GridData(GridData.FILL_HORIZONTAL);
		projectNameText.setLayoutData(projectTextData);
	  
	  projectNameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (!projectNameText.isDisposed()) {
					projectNameStr = projectNameText.getText();
				}
			}
		});

	  typeCombo  = new Combo(textGroup, SWT.READ_ONLY);
	  GridData typeComboData = new GridData(GridData.FILL_HORIZONTAL);
		typeCombo.setLayoutData(typeComboData);
	  typeCombo.add(IpkDeployMessage.getString("JavaApplicationText"));
	  typeCombo.add(IpkDeployMessage.getString("JavaAppletText"));
	  typeCombo.select(0);
	  
	  typeCombo.addSelectionListener(new SelectionAdapter() {
		  public void widgetSelected(SelectionEvent event) {
			  Combo combo = (Combo) event.getSource();
			  int index = combo.getSelectionIndex();
			  if(index > -1) {
			  	projectTypeStr = combo.getItem(index);
			  }
			}
		});
	   	
	  versionText = new Text(textGroup, SWT.SINGLE | SWT.BORDER);
	  GridData versionTextData = new GridData(GridData.FILL_HORIZONTAL);
	  versionText.setLayoutData(versionTextData);
	  
	  versionText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if(!projectNameText.isDisposed()) {
					versionStr = versionText.getText();
				}
			}
		});
	   
		descriptionText = new Text(textGroup, SWT.SINGLE | SWT.BORDER);
		GridData descriptionTextData = new GridData(GridData.FILL_HORIZONTAL);
		descriptionText.setLayoutData(descriptionTextData);
		
		descriptionText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (!descriptionText.isDisposed()) {
					descriptionStr = descriptionText.getText();
				}
			}
		});
		
		providerText = new Text(textGroup, SWT.SINGLE | SWT.BORDER);
		GridData providerTextData = new GridData(GridData.FILL_HORIZONTAL);
		providerText.setLayoutData(providerTextData);
		
		providerText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (!providerText.isDisposed()) {
					providerStr = providerText.getText();
				}
			}
		});
		
		providerMailText = new Text(textGroup, SWT.SINGLE | SWT.BORDER);
		GridData providerMailTextData = new GridData(GridData.FILL_HORIZONTAL);
		providerMailText.setLayoutData(providerMailTextData);
		
		providerMailText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (!providerMailText.isDisposed()) {
					providerMailStr = providerMailText.getText();
				}
			}
		});
		
		
	  	
	  iconText = new Text(textGroup, SWT.SINGLE | SWT.BORDER);
	  GridData iconTextTextData = new GridData(GridData.FILL_HORIZONTAL);
		iconText.setLayoutData(iconTextTextData);
		
		iconText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (!iconText.isDisposed()) {
					iconStr = iconText.getText();
				}
			}
		});
		
		mainClassText = new Text(textGroup, SWT.SINGLE | SWT.BORDER);
		mainClassText.setEditable(false);
	  GridData mainClassTextData = new GridData(GridData.FILL_HORIZONTAL);
		mainClassText.setLayoutData(mainClassTextData);
		
		mainClassText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (!mainClassText.isDisposed()) {
					mainClassStr = mainClassText.getText();
				}
			}
		});
		
		Group resourceGroup = new Group(composite,SWT.NONE);
		GridLayout resourceGridLayout = new GridLayout();
		resourceGridLayout.numColumns = 2;
		resourceGroup.setLayout(resourceGridLayout);
		resourceGroup.setText(IpkDeployMessage.getString("ResourceProperties")); 
		resourceGroup.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		
		// This compiste collects the add and remove resource buttons
		Composite buttonGroup = new Composite(resourceGroup, SWT.NONE);
		GridLayout buttonGroupLayout = new GridLayout();
		buttonGroupLayout.numColumns = 1;
		buttonGroup.setLayout(buttonGroupLayout);
		GridData buttonLayoutData = new GridData(GridData.FILL_VERTICAL); 
		buttonLayoutData.widthHint = 90;
		buttonGroup.setLayoutData(buttonLayoutData);      	
		addRes = new Button(buttonGroup, SWT.PUSH);

		addRes.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {				
				String lastPath = null;
				ClassConstantsReflector ccr = new ClassConstantsReflector();
				
				addResFileDialog = new FileDialog(getShell(), SWT.OPEN);
				addResFileDialog.setText(IpkDeployMessage.getString("AddResourceFileDialogTitle"));
				addResFileDialog.setFilterExtensions(RESOURCE_FILTERS);
		
				if (lastPath != null)
					addResFileDialog.setFilterPath(lastPath);
			
				String filename = addResFileDialog.open();
				lastPath = addResFileDialog.getFilterPath();
				if (filename == null)
					return;
			
				resourceList.add(filename);
				
				if(filename.endsWith(".JAR") || filename.endsWith(".jar")) {
					String jarMainClass = null;
					try {
						jarMainClass = IpkgStreamWriter.getMainClassName(filename);
						if(jarMainClass != null) {
							IpkDeployWizardPage.this.mainClassText.setText(jarMainClass);
							// try to create a sample application name from the main class name
							String appName = jarMainClass.substring(jarMainClass.lastIndexOf('.')+1,jarMainClass.length());
							IpkDeployWizardPage.this.projectNameText.setText(appName);
							IpkDeployWizardPage.this.classMap.put((String) jarMainClass, (String) filename);
						} else {
							IpkDeployWizardPage.this.mainClassText.setText(IpkDeployMessage.getString("NoMainClassFound"));
						}
					} catch(IOException e) {
					  IpkDeployWizardPage.this.mainClassText.setText(IpkDeployMessage.getString("NoMainClassFound"));	
					}
				} else if(filename.endsWith(".png") || filename.endsWith(".PNG")) {
					IpkDeployWizardPage.this.iconText.setText(filename);
				}
				
			}
		});	
		
		addRes.setText(IpkDeployMessage.getString("AddButtonLabelText"));
		GridData addResData = new GridData(GridData.FILL_HORIZONTAL);
		addResData.widthHint = 75;
		addResData.heightHint = 25;
		addRes.setLayoutData(addResData);
		removeRes = new Button(buttonGroup, SWT.PUSH);
		removeRes.setText(IpkDeployMessage.getString("RemoveButtonLabelText"));
		GridData removeResData = new GridData(GridData.FILL_HORIZONTAL);
		removeResData.widthHint = 75;
		removeResData.heightHint = 25;
		removeRes.setLayoutData(removeResData);
		removeRes.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				if(selectedIndex > -1) {
					resourceList.remove(selectedIndex);
				}	
			}
		});
		
		
		// This list composite layouts the scrolled ressource list
		Composite listGroup = new Composite(resourceGroup, SWT.NONE);
		GridLayout listGroupLayout = new GridLayout();
		listGroupLayout.numColumns = 1;
		listGroup.setLayout(listGroupLayout);
		GridData listLayoutData = new GridData(GridData.FILL_BOTH); 
		listGroup.setLayoutData(listLayoutData);      	
		resourceList = new List(listGroup, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);
		resourceList.addSelectionListener(new SelectionAdapter () {
			public void widgetSelected(SelectionEvent e)	{
				resourceList = (List) e.getSource();
				selectedIndex = resourceList.getSelectionIndex();
				if(selectedIndex > -1) {
					String selectedItem = resourceList.getItem(selectedIndex);
				}
			}
		});
		
		GridData resourceListGridData = new GridData(GridData.FILL_BOTH);
		resourceListGridData.verticalSpan = 4;
		int listHeight = resourceList.getItemHeight() * 10;
		Rectangle trim = resourceList.computeTrim(0, 0, 0, listHeight);
    resourceListGridData.heightHint = trim.height;
    resourceList.setLayoutData(resourceListGridData);		        
	}
	
	private boolean checkPageComplete() {
		boolean isComplete = false;
	
		// check the text box values
    if((projectNameStr.length() > 0) &&
    	(projectTypeStr.length() > 0) &&  
    	(versionStr.length() > 0) &&
    	(descriptionStr.length() > 0) &&
    	(providerStr.length() > 0) && 
    	(iconStr.length() > 0) &&
    	(mainClassStr.length() > 0)) {
    	
    	isComplete = true;
    }
    
    this.setPageComplete(isComplete);
    return isComplete;
	}
	
	public Ipkg getIpkg() {
		// create a new ipkg structure instance
		Ipkg ipkg = new Ipkg(); 
		String name = this.projectNameStr;
		ipkg.setName(name);
		ipkg.setIconFilename(this.iconStr);
		ipkg.setMainClass(this.mainClassStr);
		 
    Iterator classFileIter = classMap.values().iterator();
    while (classFileIter.hasNext()) {
    	String classFileName = (String) classFileIter.next();
			ipkg.addClass((String) classFileName);
    }

    // create a new control instance
		Control control = new Control(); // new control section
		control.setPackageName(name+"-app");
		control.setMaintainerName(this.providerStr);
    control.setMaintainerEmail(this.providerMailStr);
    control.setVersion(this.versionStr);
    control.setDescription(this.descriptionStr);
		ipkg.setControl(control);
		// create the desktop entries
		Properties props = new Properties();
    props.put("Comment",this.descriptionStr);
    props.put("Exec",name);
    props.put("Icon",name);
    props.put("Type","Application");
    props.put("Name",name.substring(0,1).toUpperCase()+name.substring(1));
    ipkg.setDesktop(props);

		return ipkg;
	}
	

	/**
	 * Method finish.
	 * @return boolean
	 */
	public boolean finish() {
		if (!checkPageComplete()) {
        	return false;
        }
		return true;
	}
}
