package de.wartala.eclipse.IpkDeploy;

 
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;

/**
 * The main plugin class to be used for the desktop.
 * @author Ramon Wartala
 */

public class IpkDeployWizard extends Wizard implements IExportWizard {
	IpkDeployWizardPage wizardPage;
	
	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		//this.setDialogSettings(IpkDeployPlugin.getDefault().getDialogSettings());
		this.setWindowTitle(IpkDeployMessage.getString("WindowTitle"));
		this.setDefaultPageImageDescriptor(IpkDeployPlugin.getImageDescriptor("icons/ipkwiz.gif"));
		this.setHelpAvailable(false);
		this.setNeedsProgressMonitor(true);
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#canFinish()
	 */
	public boolean canFinish() {
		return true;
	}
	
	public void addPages() {
		wizardPage = new IpkDeployWizardPage();
		addPage(wizardPage);
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {	
		IpkDeployCreationOperation ipkCreationOperation = new IpkDeployCreationOperation(wizardPage);
		try {
	    	new ProgressMonitorDialog(this.getShell()).run(true, true, ipkCreationOperation);
		} catch (InvocationTargetException e) {
			handleException(e.getTargetException());
			return false;
		} catch  (InterruptedException e) {
			return false;
		}


		return wizardPage.finish();
	}
	
	private void handleException(Throwable target) {
		
	}

	
}
