package de.wartala.eclipse.IpkDeploy;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class IpkDeployMessage {
	private static final String RESOURCE_BUNDLE= "de.wartala.eclipse.IpkDeploy.IpkDeploy";
	private static ResourceBundle resourceBundle= ResourceBundle.getBundle(RESOURCE_BUNDLE);

	private IpkDeployMessage() {
	}
	
	/**
	 * Returns the formatted message for the given key in
	 * the resource bundle. 
	 *
	 * @param key the resource name
	 * @param args the message arguments
	 * @return the string
	 */	
	public static String format(String key, Object[] args) {
		return MessageFormat.format(getString(key),args);
	}


	/**
	 * Returns the resource object with the given key in
	 * the resource bundle. If there isn't any value under
	 * the given key, the key is returned, surrounded by '!'s.
	 *
	 * @param key the resource name
	 * @return the string
	 */	
	public static String getString(String key) {
		try {
			return resourceBundle.getString(key);
		} catch (MissingResourceException e) {
			return "!" + key + "!";//$NON-NLS-2$ //$NON-NLS-1$
		}
	}
}
