package de.wartala.eclipse.IpkDeploy;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class IpkDeployCreationOperation implements IRunnableWithProgress  {
	private IpkDeployWizardPage wizardPage;
	
	public IpkDeployCreationOperation(IpkDeployWizardPage page) {
		this.wizardPage = page;
	}
	
	public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
		if (monitor == null) {
			monitor= new NullProgressMonitor();
		}
		
		try {
			monitor.beginTask(IpkDeployMessage.getString("BeginIpkCreation"), 6);
			IWorkspaceRoot root= IpkDeployPlugin.getWorkspace().getRoot();
			// get Ipkg object
			Ipkg ipkg = this.wizardPage.getIpkg();  
      Thread.sleep(200);
      monitor.worked(1); 
      // create a legal filename
      String filename = ipkg.getName()+"_"+ipkg.getControl().getVersion()+"_"+ipkg.getControl().getArchitecture()+".ipk";			
			Thread.sleep(200);
      monitor.worked(1);      
      // create a output stream
			FileOutputStream out = new FileOutputStream(filename);
    	Thread.sleep(200);
      monitor.worked(1);
      // create a ipkg output stream
    	IpkgOutput io = new IpkgOutput();
      Thread.sleep(200);
      monitor.worked(1);
      // write the ipkg to the output stream
      io.write(ipkg, out);
    	Thread.sleep(200);
      monitor.worked(1);
      out.flush();
      out.close();
      Thread.sleep(200);
      monitor.worked(1);
		} catch(Exception e) {		
			e.printStackTrace();
		} finally {
			monitor.done();
		}
	}
}
