/*
 * Decompiled with CFR 0.152.
 */
package de.wartala.eclipse.IpkDeploy;

import com.ice.tar.TarEntry;
import de.wartala.eclipse.IpkDeploy.ClassConstantsReflector;
import de.wartala.eclipse.IpkDeploy.Control;
import de.wartala.eclipse.IpkDeploy.Ipkg;
import de.wartala.eclipse.IpkDeploy.IpkgStreamWriter;
import de.wartala.eclipse.IpkDeploy.IpkgStringWriter;
import de.wartala.eclipse.IpkDeploy.TarGzOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;

public class IpkgOutput {
    public void write(Ipkg ipkg, OutputStream out) throws IOException {
        String name = ipkg.getName();
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        TarGzOutputStream tgz = new TarGzOutputStream(baos1);
        TarEntry entry = new TarEntry(String.valueOf(name) + "/home/QtPalmtop/apps/Jeode/" + name + ".desktop");
        tgz.putNextEntry(entry);
        this.writeDesktop((OutputStream)((Object)tgz), ipkg);
        tgz.closeEntry();
        entry = new TarEntry(String.valueOf(name) + "/home/QtPalmtop/bin/" + name);
        tgz.putNextEntry(entry);
        this.writeScript((OutputStream)((Object)tgz), ipkg);
        tgz.closeEntry();
        entry = new TarEntry(String.valueOf(name) + "/home/QtPalmtop/pics/" + name + ".png");
        File file = new File(ipkg.getIconFilename());
        entry.setSize(file.length());
        tgz.putNextEntry(entry);
        this.writeFile((OutputStream)((Object)tgz), file);
        tgz.closeEntry();
        ClassConstantsReflector ccr = new ClassConstantsReflector();
        Iterator iterator = ipkg.iterateClasses();
        while (iterator.hasNext()) {
            String filename = (String)iterator.next();
            String classname = null;
            classname = filename.endsWith(".class") ? String.valueOf(ccr.getFullyQualifiedName(filename)) + ".class" : IpkgStringWriter.getChomp(filename, "/");
            entry = new TarEntry(String.valueOf(name) + "/home/QtPalmtop/java/" + classname);
            file = new File(filename);
            entry.setSize(file.length());
            tgz.putNextEntry(entry);
            this.writeFile((OutputStream)((Object)tgz), file);
            tgz.closeEntry();
        }
        tgz.finish();
        tgz.close();
        ipkg.getControl().setSize(baos1.size());
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        tgz = new TarGzOutputStream(baos2);
        entry = new TarEntry(String.valueOf(name) + "/CONTROL/control");
        tgz.putNextEntry(entry);
        this.writeControl((OutputStream)((Object)tgz), ipkg);
        tgz.closeEntry();
        tgz.finish();
        tgz.close();
        tgz = new TarGzOutputStream(out);
        TarEntry dataEntry = new TarEntry("data.tar.gz");
        tgz.putNextEntry(dataEntry);
        tgz.write(baos1.toByteArray());
        tgz.closeEntry();
        TarEntry ctrlEntry = new TarEntry("control.tar.gz");
        tgz.putNextEntry(ctrlEntry);
        tgz.write(baos2.toByteArray());
        tgz.closeEntry();
        tgz.finish();
        tgz.close();
    }

    private void writeDesktop(OutputStream out, Ipkg ipkg) throws IOException {
        out.write("[Desktop]\n".getBytes());
        Properties props = ipkg.getDesktop();
        Iterator<Object> iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = props.get(key);
            out.write(key.toString().getBytes());
            out.write("=".getBytes());
            out.write(value.toString().getBytes());
            out.write("\n".getBytes());
        }
    }

    private void writeScript(OutputStream out, Ipkg ipkg) throws IOException {
        out.write(". /home/QtPalmtop/bin/installdir.sh\n$QPEDIR/bin/evm -Xappname=".getBytes());
        out.write(ipkg.getName().getBytes());
        out.write(" -cp $INSTALLDIR/java/".getBytes());
        out.write(ipkg.getMainClass().getBytes());
    }

    private void writeFile(OutputStream out, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        IpkgStreamWriter.pushStream(fis, out);
    }

    private void writeControl(OutputStream out, Ipkg ipkg) throws IOException {
        Control control = ipkg.getControl();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Package: ");
        buffer.append(control.getPackageName());
        buffer.append("\nInstalled size: ");
        buffer.append(control.getSizeAsString());
        buffer.append("\nFilename: ");
        buffer.append(control.getFilename());
        buffer.append("\nSection: ");
        buffer.append(control.getSection());
        buffer.append("\nMaintainer: ");
        buffer.append(control.getMaintainerName());
        buffer.append(" <");
        buffer.append(control.getMaintainerEmail());
        buffer.append(">\nArchitecture: ");
        buffer.append(control.getArchitecture());
        buffer.append("\nVersion: ");
        buffer.append(control.getVersion());
        buffer.append("\nDescription: ");
        buffer.append(control.getDescription());
        out.write(buffer.toString().getBytes());
    }

    public Ipkg read(InputStream in) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

