/**
 * Copyright @ 2002 Lars Rwekamp (lars.roewekamp@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.wstutorial.translator;


/* imports */

import de.ix.wstutorial.util.soap.SOAPRPCResponse;

import javax.servlet.http.*;
import javax.servlet.*;

import javax.xml.soap.*;
import javax.xml.soap.Name;
import javax.xml.messaging.URLEndpoint;


/**
 * Einfaches Servlet zum Versenden einer SOAP Anfrage
 * an den BabelFish Web Service von xMethods.
 *
 * Das Servlet baut die Anfrage zunaechst auf und setzt sie
 * anschliessend ab. Die erhaltene Antwort wird mittels
 * PrintWriter Objekt direkt als XML ausgegeben.
 *
 */
public class TranslationServlet extends HttpServlet {


    /* private */

    /**
     *  Zielseite, die nach erfolgreicher Abarbeitung angezeigt werden soll.
     */
    private static final String TARGET_VIEW = "/jsp/de/babelfish.jsp";


    /**
     *  Namespace Prefix fuer den SOAP Request
     */
    private static final String NS_REQUEST_PREFIX = "m";

    /**
     *  Namespace URI fuer den SOAP Request
     */
    private static final String NS_REQUEST_URI = "urn:xmethodsBabelFish";

    /**
     *  Url des SOAP Request Empfaengers - direkter Zugriff
     */
    private static final String ENDPOINT_URL = "http://services.xmethods.net:80/perl/soaplite.cgi";


    /**
     *  Url des SOAP Request Empfaengers - Zugriff via TCPMonitor am Port 8070
     */
    // private static final String ENDPOINT_URL = "http://localhost:8070/perl/soaplite.cgi";


    /**
     *  SOAP Request - Methodenname
     */
    private static final String SOAP_METHOD_NAME = "BabelFish";

    /**
     *  SOAP Request - Parametername fuer "Uebersetzungsmodus"
     */
    private static final String SOAP_IN_PARAM_TRANSLATION_MODE = "translationmode";

    /**
     *  SOAP Request - Parametername fuer die zu uebersetzenden Daten
     */
    private static final String SOAP_IN_PARAM_SOURCE_DATA = "sourcedata";

    /**
     *  HTTP Request - Parametername fuer "Uebersetzungsmodus"
     */
    private static final String PARAM_FROM_LANG_TO_LANG = "fromTo";

    /**
     *  HTTP Request - Parametername fuer die zu uebersetzenden Daten
     */
    private static final String PARAM_TEXT_TO_TRANSLATE = "orgText";


    /**
      *  HTTP Request - Attribute Flag fuer vorhandene Uebersetzung
      */
     private static final String ATTR_TRANSLATION_FLAG = "translationFlag";

    /**
      *  HTTP Request - Default Wert fuer Attribute
      */
     private static final String DEAFULT_TRANSLATION_FLAG = "TRUE";

    /**
      *  HTTP Request - Attribute fuer "Originaltext"
      */
     private static final String ATTR_ORIGINAL_TEXT = "originalText";

     /**
      *  HTTP Request - Attribute fuer "Originaltext"
      */
     private static final String ATTR_TRANSLATION = "translation";


    /**
     * Vorgabewert fuer den Uebersetzungsmodus: vom Deutschen ins Englische
     */
    private static final String DEFAULT_FROM_LANG_TO_LANG = "de_en";

    /**
     * Vorgabewert fuer den zu uebersetzenden Text
     */
    private static final String DEFAULT_TEXT_TO_TRANSLATE = "Information";


    /**
     * SOAP Verbindung
     */
    SOAPConnection connection;


    /**
     * Initialisierung des Servlets.
     *
     * @param servletConfig       Aktuelle Konfiguration des Servlets
     * @throws ServletException   Servlet spezifische Exception
     */

    public void init(ServletConfig servletConfig) throws
            ServletException {
        super.init(servletConfig);
    }


    /**
     * Verabeitung eines HTTP Get Aufrufs.
     *
     * Diese Methode baut den SOAP Request auf, setzt ihn ab
     * und gibt den erhaltenen SOAP Response als XML wieder
     * aus.
     *
     * @param request              HTTP Servlet Request Objekt
     * @param response             HTTP Servlet Response Objekt
     * @throws ServletException    Servlet spezifische Exception
     */

    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {


        /* initialer Aufbau der SOAP Connection */

        try {
            SOAPConnectionFactory soapConnetcionFactory = SOAPConnectionFactory.newInstance();
            connection = soapConnetcionFactory.createConnection();
        } catch (Exception e) {

        }

        try {

            /* Auslesen der Parameter aus dem HTTP Request */

            String textToTranslate = request.getParameter(PARAM_TEXT_TO_TRANSLATE);
            String translateFromTo = request.getParameter(PARAM_FROM_LANG_TO_LANG);

            if (textToTranslate == null || textToTranslate.equals("")) {
                textToTranslate = DEFAULT_TEXT_TO_TRANSLATE;
            }

            if (translateFromTo == null || translateFromTo.equals("")) {
                translateFromTo = DEFAULT_FROM_LANG_TO_LANG;
            }

            /* Aufbau der SOAP Message - Message erzeugen */

            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();

            /* Aufbau der SOAP Message - SOAP Part erzeugen */

            SOAPPart soapPart = message.getSOAPPart();

            /* Aufbau der SOAP Message - SOAP Envelope erzeugen */

            SOAPEnvelope envelope = soapPart.getEnvelope();


            /* Aufbau der SOAP Message - SOAP Header erzeugen */

            SOAPHeader header = envelope.getHeader();
            header.detachNode();

            /* Aufbau der SOAP Message - SOAP Body erzeugen */

            SOAPBody body = envelope.getBody();


            /* Aufbau der SOAP Message - SOAP Body Element setzen: Methodenname */

            Name bodyName = envelope.createName(SOAP_METHOD_NAME, NS_REQUEST_PREFIX, NS_REQUEST_URI);
            SOAPBodyElement babelFishMethod = body.addBodyElement(bodyName);


            /* Aufbau der SOAP Message - SOAP Element setzen: Parameter - translationmode */

            Name translationModeName = envelope.createName(SOAP_IN_PARAM_TRANSLATION_MODE);
            SOAPElement translationModeParam = babelFishMethod.addChildElement(translationModeName);
            translationModeParam.addTextNode(translateFromTo);

            /* Aufbau der SOAP Message - SOAP Element setzen: Parameter - sourcedata */

            Name sourceDataName = envelope.createName(SOAP_IN_PARAM_SOURCE_DATA);
            SOAPElement sourceDataParam = babelFishMethod.addChildElement(sourceDataName);
            sourceDataParam.addTextNode(textToTranslate);

            /* SOAP Endpoint URL (Empfaenger) setzen */

            URLEndpoint endpoint = new URLEndpoint(ENDPOINT_URL);

            /* SOAP Message versenden und SOAP Response erhalten */

            SOAPMessage soapResponse = connection.call(message, endpoint);

            /* SOAP RPC Response extrahieren */

            SOAPRPCResponse soapRpcResponse = SOAPRPCResponse.getSOAPRPCResponse(soapResponse);

            /* Uebersetzung aus dem Return Element extrahieren */

            String translation = null;
            if (soapRpcResponse != null) {

                SOAPElement returnElement = soapRpcResponse.getReturnElement();
                translation = returnElement.getValue();

            } else {

                translation = "Fehler bei der bersetzung von: " + textToTranslate;
            }


            /* SOAP Connection wieder schliessen */

            connection.close();

            /* Werte fuer spaetere Darstellung in der JSP setzen  */
            request.setAttribute(ATTR_TRANSLATION_FLAG, DEAFULT_TRANSLATION_FLAG);
            request.setAttribute(ATTR_ORIGINAL_TEXT, textToTranslate);
            request.setAttribute(ATTR_TRANSLATION, translation);

            /* JSP aufrufen */

            request.getRequestDispatcher(TARGET_VIEW).forward(request, response);

        } catch (Exception e) {

            /* generelles Exception Handling */

            e.printStackTrace();
            e.getMessage();

        }

    }


}




