/**
  *  Copyright @ 2002 Lars Rwekamp (lars.roewekamp@openKnowlege.de)
  *
  * Source is only for non commercialand coaching usage.
  *
  * Not Warranty to use it.
  */

package de.ix.wstutorial.stockquote;


/* imports */


import javax.servlet.http.*;
import javax.servlet.*;

import de.ix.wstutorial.stockquote.generated.*;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;

/**
 * Einfaches Servlet zum Versenden einer SOAP Anfrage
 * an den Stock Quote Web Service von xMethods.
 *
 * Das Servlet baut die Anfrage zunaechst auf und setzt sie
 * anschliessend ab. Es nutzt dabei generierte Stubs, die
 * durch das Tool xrpcc erzeugt worden.
 *
 */
public class StockQuoteServlet extends HttpServlet {


    /* private */

    /*
     *  Zielseite, die nach erfolgreicher Abarbeitung angezeigt werden soll.
     */
    private static final String TARGET_VIEW = "/jsp/de/stockquote.jsp";


    /*
     * Parameter, die als Eingabe erwartet werden
     */
    private final static String PARAM_SYMBOL = "symbol";


    /*
     * Standardwert, der bei fehlender Eingabe gesetzt wird.
     */
    private final static String DEFAULT_SYMBOL = "SUNW";


    /*
     * Attribute, die nach der Abarbeitung im Request Objekt gesetzt
     * und innerhalb der JSP ausgewertet werden.
     */
    private final static String ATTR_SYMBOL               = "symbol";
    private final static String ATTR_VALUE                = "value";
    private final static String ATTR_STOCK_QUOTE_FLAG     = "stockQuoteFlag";
    private final static String DEFAULT_STOCK_QUOTE_FLAG  = "TRUE";

    /*
    *  Fehlermeldungen
    */
    private final static String ATTR_STOCK_QUOTE_ERROR_FLAG     = "stockQuoteErrorFlag";
    private final static String DEFAULT_STOCK_QUOTE_ERROR_FLAG  = "TRUE";
    private final static String ATTR_ERROR_TEXT                 = "errorText";
    private final static String ATTR_ERROR_UNKNOWN_SYMBOLE      = "Kein Kurswert fr das angegebene Symbol verfrgbar.";



    /**
     * Initialisierung des Servlets.
     *
     * @param servletConfig       Aktuelle Konfiguration des Servlets
     * @throws javax.servlet.ServletException   Servlet spezifische Exception
     */

    public void init(ServletConfig servletConfig) throws
            ServletException {
        super.init(servletConfig);
    }


    /**
     * Verabeitung eines HTTP Get Aufrufs.
     *
     * Diese Methode ruft mit Hilfe des JAX-RPC API einen
     * Web Service auf und stellt das Ergebins zur Verfuegung.
     *
     * @param request              HTTP Servlet Request Objekt
     * @param response             HTTP Servlet Response Objekt
     * @throws javax.servlet.ServletException    Servlet spezifische Exception
     */

    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {


        try {

            /* Auslesen der Parameter aus dem HTTP Request.
               Ist kein Parameter vorhanden wird ein
               Standardwert gesetzt.
            */

            String symbol =  request.getParameter(PARAM_SYMBOL);

            if (symbol == null || symbol.equals("")) {
                symbol = DEFAULT_SYMBOL;
            }


            /* Aufruf des eigentlichen Web Services mit Hilfe
               der generierten Klassen und dem uebergebenen
               Parameter.
             */

            StockQuoteService service = new StockQuoteService_Impl();
            StockQuotePortType stub   = (StockQuotePortType_Stub)service.getStockQuotePort();
            float stockQuote          = stub.getQuote(symbol);

            /* Werte fuer spaetere Darstellung in der JSP setzen  */

            request.setAttribute(ATTR_STOCK_QUOTE_FLAG, DEFAULT_STOCK_QUOTE_FLAG);
            request.setAttribute(ATTR_SYMBOL, symbol);

            /* Test, ob Symbol bekannt ist, falls nicht liefert der Service einen
               Wert kleiner 0.00 zurueck
            */

            if (stockQuote >= 0.00 ) {

                /* Gelieferten Wert im Request Objekt setzen. Dies geschiet bereits in
                   formatierter Form, da in diesem kleinen Beispiel auf die Verwendung
                   von entsprechenden Customer Tags innerhalb der JSPs verzichtet werden
                   soll.
                 */
                NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(Locale.US);
                request.setAttribute(ATTR_VALUE,  currencyFormat.format(stockQuote ));

            } else {

                /* Fehlernachricht fuer die spaetere Anzeige in der JSP setzen */
                request.setAttribute(ATTR_VALUE,  ATTR_ERROR_UNKNOWN_SYMBOLE);
            }


            /* Ziel JSP zur Anzeige des Ergebnisses aufrufen */

           request.getRequestDispatcher(TARGET_VIEW).forward(request, response);



        } catch (Exception e) {

            /* generelles, rudimentares Exception Handling */

            e.printStackTrace();
            e.getMessage();

        }

    }


}

