
/**
 *  Copyright @ 2002 Lars Rwekamp (lars.roewekamp@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */
package de.ix.wstutorial.registrybrowser;

/**
 * Einfache Klasse zur rudiemntaeren Beschreibung
 * eines XML Registry Eintrages vom Typ "Service".
 *
 */

public class ShortService {

    /**
     * Name des Service.
     */
    private String name;

    /**
     * Beschreibung des Servcie.
     */
    private String description;

    /**
     * Eindeutiger Schluessel des Service.
     */
    private String key;

    /**
     * Default Konstruktor.
     *
     * @param name         Name des Service
     * @param description  Beschreibung
     * @param key          Eindeutiger Schluessel
     */
    public ShortService(String name, String description, String key) {
        this.name = name;
        this.description = description;
        this.key = key;
    }

    /**
     * Getter Methode fuer den privaten Class Member </code>name</code>.
     *
     * @return Namen des Service.
     */
    public String getName() {
        return name;
    }


    /**
     * Getter Methode fuer den privaten Class Member </code>name</code>.
     *
     * @param   defaultName  Vorgabewert, falls name == null.
     * @return  defaultName, falls name == null, sonst Name
     *          des Service.
     */
    public String getName(String defaultName) {
        if (name != null)
            return name;
        else
            return defaultName;
    }

    /**
     * Setter Methode fuer den privaten Class Member </code>name</code>.
     *
     * @param name  Neuer Name des Service
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Getter Methode fuer den privaten Class Member </code>description</code>.
     *
     * @return Beschreibung des Service
     */
    public String getDescription() {
        return description;
    }

    /**
     * Getter Methode fuer den privaten Class Member </code>description</code>.
     *
     * @param   defaultDescription  Vorgabewert, falls description == null.
     * @return  defaultName, falls description == null, sonst Beschreibung
     *          des Service.
     */
    public String getDescription(String defaultDescription) {
        if (description != null)
            return description;
        else
            return defaultDescription;
    }


    /**
     * Setter Methode fuer den privaten Class Member </code>description</code>.
     *
     * @param description  Neue Beschreibung des Service
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
      * Getter Methode fuer den privaten Class Member </code>jey</code>.
      *
      * @return Eindeutiger Schluessel des Service
      */
    public String getKey() {
        return key;
    }


    /**
     * Setter Methode fuer den privaten Class Member </code>key</code>.
     *
     * @param key  Neuer Schluessel des Service
     */
    public void setKey(String key) {
        this.key = key;
    }

}
