/**
 * Copyright @ 2002 Lars Rwekamp (lars.roewekamp@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */
package de.ix.wstutorial.registrybrowser;

/* imports */

import java.util.Collection;

/**
 * Einfache Klasse zur rudiemntaeren Beschreibung
 * eines XML Registry Eintrages vom Typ "Organisation".
 *
 */
public class ShortOrganization {


    /**
     * Name der Organisation.
     */
    private String name;

    /**
     * Naehere Beschreibung der Organisation.
     *
     */
    private String description;

    /**
     * Eindeutiger Schluessel zur Identifikation.
     */
    private String key;

    /**
     * Collection von angebotenen Services
     */
    private Collection services;


    /**
     * Default Konstruktor.
     *
     * @param name         Name der Organisation
     * @param description  Beschreibung
     * @param key          Eindeutiger Schluessel
     * @param services     Collection von Services
     */
    public ShortOrganization(String name, String description, String key, Collection services) {
        this.name = name;
        this.description = description;
        this.key = key;
        this.services = services;
    }

    /**
     * Getter Methode fuer den privaten Class Member </code>name</code>.
     *
     * @return Namen der Organisation
     */
    public String getName() {
        return name;
    }

    /**
     * Getter Methode fuer den privaten Class Member </code>name</code>.
     *
     * @param   defaultName  Vorgabewert, falls name == null.
     * @return  defaultName, falls name == null, sonst Name
     *          der Organisation.
     */
    public String getName(String defaultName) {
        if (name != null)
            return name;
        else
            return defaultName;
    }


    /**
     * Setter Methode fuer den privaten Class Member </code>name</code>.
     *
     * @param name  Neuer Name der Organisation
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Getter Methode fuer den privaten Class Member </code>description</code>.
     *
     * @return Beschreibung der Organisation
     */
    public String getDescription() {
        return description;
    }

    /**
     * Getter Methode fuer den privaten Class Member </code>description</code>.
     *
     * @param   defaultDescription  Vorgabewert, falls description == null.
     * @return  defaultName, falls description == null, sonst Beschreibung
     *          der Organisation.
     */
    public String getDescription(String defaultDescription) {
        if (description != null)
            return description;
        else
            return defaultDescription;
    }


    /**
     * Setter Methode fuer den privaten Class Member </code>description</code>.
     *
     * @param description  Neue Beschreibung der Organisation
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
      * Getter Methode fuer den privaten Class Member </code>jey</code>.
      *
      * @return Eindeutiger Schluessel der Organisation
      */
    public String getKey() {
        return key;
    }


    /**
     * Setter Methode fuer den privaten Class Member </code>key</code>.
     *
     * @param key  Neuer Schluessel der Organisation
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
      * Getter Methode fuer den privaten Class Member </code>service</code>.
      *
      * @return Collection von Services.
      */
    public Collection getServices() {
        return services;
    }

    /**
     * Setter Methode fuer den privaten Class Member </code>services</code>.
     *
     * @param services  Neue Services der Organisation
     */
    public void setServices(Collection services) {
        this.services = services;
    }
}
